"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderPoints = renderPoints;
exports.renderPointGroup = renderPointGroup;
const panel_clipping_1 = require("./panel_clipping");
const shapes_1 = require("./primitives/shapes");
const panel_transform_1 = require("./utils/panel_transform");
const color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
const common_1 = require("../../../../utils/common");
const points_1 = require("../../rendering/points");
function renderPoints(ctx, points, highlightState, pointStyle, lineStrokeWidth, seriesMinPointDistance, pointsDistanceVisibilityThreshold, hasConnectingLine) {
    const isHiddenOnAuto = pointStyle.visible === 'auto' && (seriesMinPointDistance < pointsDistanceVisibilityThreshold || points.length <= 1);
    const hideDataPoints = pointStyle.visible === 'never' || isHiddenOnAuto;
    const hideIsolatedDataPoints = hasConnectingLine && hideDataPoints;
    const useIsolatedPointRadius = hideDataPoints && !hasConnectingLine;
    const opacity = highlightState === 'dimmed' && 'opacity' in pointStyle.dimmed ? pointStyle.dimmed.opacity : pointStyle.opacity;
    const dimmedFill = highlightState === 'dimmed' && 'fill' in pointStyle.dimmed ? (0, color_library_wrappers_1.colorToRgba)(pointStyle.dimmed.fill) : undefined;
    const dimmedStroke = highlightState === 'dimmed' && 'stroke' in pointStyle.dimmed ? (0, color_library_wrappers_1.colorToRgba)(pointStyle.dimmed.stroke) : undefined;
    const focusedStrokeWidth = highlightState === 'focused' && pointStyle.focused ? pointStyle.focused.strokeWidth : undefined;
    points.forEach(({ x, y, radius, transform, style, isolated, color }) => {
        if ((isolated && hideIsolatedDataPoints) || (!isolated && hideDataPoints)) {
            return;
        }
        const coordinates = {
            x: x + transform.x,
            y: y + transform.y,
            radius: isolated && useIsolatedPointRadius ? (0, points_1.isolatedPointRadius)(lineStrokeWidth) : radius,
        };
        const fillColor = isolated && useIsolatedPointRadius && pointStyle?.stroke
            ? (0, color_library_wrappers_1.colorToRgba)((0, common_1.getColorFromVariant)(color, pointStyle.stroke))
            : style.fill.color;
        const fill = { color: (0, color_library_wrappers_1.overrideOpacity)(dimmedFill ?? fillColor, (fillOpacity) => fillOpacity * opacity) };
        const stroke = {
            ...style.stroke,
            color: (0, color_library_wrappers_1.overrideOpacity)(dimmedStroke ?? style.stroke.color, (fillOpacity) => fillOpacity * opacity),
            width: isolated && useIsolatedPointRadius ? 0 : focusedStrokeWidth ?? style.stroke.width,
        };
        (0, shapes_1.renderShape)(ctx, style.shape, coordinates, fill, stroke);
    });
}
function renderPointGroup(ctx, points, geometryStateStyles, rotation, renderingArea, shouldClip) {
    points
        .slice()
        .sort(({ radius: a }, { radius: b }) => b - a)
        .forEach(({ x, y, radius, transform, style, seriesIdentifier: { key }, panel }) => {
        const opacity = geometryStateStyles[key]?.opacity ?? 1;
        const fill = { color: (0, color_library_wrappers_1.overrideOpacity)(style.fill.color, (fillOpacity) => fillOpacity * opacity) };
        const stroke = {
            ...style.stroke,
            color: (0, color_library_wrappers_1.overrideOpacity)(style.stroke.color, (fillOpacity) => fillOpacity * opacity),
        };
        const coordinates = { x: x + transform.x, y, radius };
        const renderer = () => (0, shapes_1.renderShape)(ctx, style.shape, coordinates, fill, stroke);
        const clippings = { area: (0, panel_clipping_1.getPanelClipping)(panel, rotation), shouldClip };
        (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, renderer, clippings);
    });
}
//# sourceMappingURL=points.js.map