"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTicks = renderTicks;
const color_library_wrappers_1 = require("../../../../../common/color_library_wrappers");
const line_1 = require("../../../../../renderers/canvas/primitives/line");
const common_1 = require("../../../../../utils/common");
const axis_type_utils_1 = require("../../../utils/axis_type_utils");
const grid_lines_1 = require("../../../utils/grid_lines");
const BASELINE_CORRECTION = 2;
function renderTicks(ctx, ticks, axisProps) {
    const tickLines = ticks.reduce((acc, tick) => {
        const line = getTickLineCoordinates(tick, axisProps);
        if (line)
            acc.push(line);
        return acc;
    }, []);
    (0, line_1.renderMultiLine)(ctx, tickLines, {
        color: (0, color_library_wrappers_1.colorToRgba)(axisProps.axisStyle.tickLine.stroke),
        width: axisProps.axisStyle.tickLine.strokeWidth,
    });
}
function getTickLineCoordinates({ position, domainClampedPosition: tickPosition, layer, detailedLayer, multilayerTimeAxis }, { axisSpec, size: { width, height }, axisStyle: { tickLine }, layerGirth }) {
    if (Math.abs(tickPosition - position) > grid_lines_1.OUTSIDE_RANGE_TOLERANCE)
        return;
    const { position: axisPosition } = axisSpec;
    const tickOnTheSide = multilayerTimeAxis && typeof layer === 'number';
    const extensionLayer = tickOnTheSide ? layer + 1 : 0;
    const tickSize = tickLine.size +
        (tickOnTheSide && (detailedLayer > 0 || !grid_lines_1.HIDE_MINOR_TIME_GRID)
            ? extensionLayer * layerGirth + (extensionLayer < 1 ? 0 : tickLine.padding - BASELINE_CORRECTION)
            : 0);
    return (0, axis_type_utils_1.isHorizontalAxis)(axisPosition)
        ? {
            x1: tickPosition,
            x2: tickPosition,
            ...(axisPosition === common_1.Position.Top ? { y1: height - tickSize, y2: height } : { y1: 0, y2: tickSize }),
        }
        : {
            y1: tickPosition,
            y2: tickPosition,
            ...(axisPosition === common_1.Position.Left ? { x1: width, x2: width - tickSize } : { x1: 0, x2: tickSize }),
        };
}
//# sourceMappingURL=tick.js.map