"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAreas = renderAreas;
const panel_clipping_1 = require("./panel_clipping");
const points_1 = require("./points");
const path_1 = require("./primitives/path");
const area_1 = require("./styles/area");
const line_1 = require("./styles/line");
const panel_transform_1 = require("./utils/panel_transform");
const canvas_1 = require("../../../../renderers/canvas");
const geometry_1 = require("../../../../utils/geometry");
function renderAreas(ctx, imgCanvas, areas, rotation, renderingArea, highlightedLegendItem) {
    const sortedRenderingAreas = areas.reduce((acc, area) => {
        const highlightState = (0, geometry_1.getGeometryHighlightState)(area.value.seriesIdentifier.key, highlightedLegendItem);
        acc[highlightState][area.value.isStacked ? 'stacked' : 'nonStacked'][area.value.isStacked ? 'unshift' : 'push'](area);
        return acc;
    }, {
        dimmed: { stacked: [], nonStacked: [] },
        focused: { stacked: [], nonStacked: [] },
        default: { stacked: [], nonStacked: [] },
    });
    (0, canvas_1.withContext)(ctx, () => {
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.default.stacked, 'default');
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.default.nonStacked, 'default');
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.dimmed.stacked, 'dimmed');
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.dimmed.nonStacked, 'dimmed');
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.focused.stacked, 'focused');
        renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, sortedRenderingAreas.focused.nonStacked, 'focused');
    });
}
function renderAreasGroup(ctx, imgCanvas, rotation, renderingArea, areas, highlighedState) {
    areas.forEach(({ panel, value: geom }) => {
        const clippings = (0, panel_clipping_1.getPanelClipping)(panel, rotation);
        if (geom.style.area.visible) {
            (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => renderArea(ctx, imgCanvas, geom, clippings, highlighedState), { area: clippings, shouldClip: true });
        }
        if (geom.style.line.visible) {
            (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => renderAreaLines(ctx, geom, clippings, highlighedState), { area: clippings, shouldClip: true });
        }
        (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => (0, points_1.renderPoints)(ctx, geom.points, highlighedState, geom.style.point, geom.style.line.strokeWidth, geom.minPointDistance, geom.style.pointVisibilityMinDistance, geom.hasFit && geom.points.length > 1), { area: clippings, shouldClip: geom.points[0]?.value.mark !== null });
    });
}
function renderArea(ctx, imgCanvas, geometry, clippings, highlightState) {
    const { area, color, transform, style, clippedRanges, shouldClip } = geometry;
    const areaFill = (0, area_1.buildAreaStyles)(ctx, imgCanvas, color, style.area, highlightState);
    const fitAreaFillThemeStyle = { ...style.fit.area, dimmed: style.area.dimmed };
    const fitAreaFill = (0, area_1.buildAreaStyles)(ctx, imgCanvas, color, fitAreaFillThemeStyle, highlightState);
    (0, path_1.renderAreaPath)(ctx, transform, area, areaFill, fitAreaFill, clippedRanges, clippings, shouldClip && style.fit.area.visible);
}
function renderAreaLines(ctx, geometry, clippings, highlightState) {
    const { lines, color, transform, style, clippedRanges, shouldClip } = geometry;
    const lineStyle = (0, line_1.buildLineStyles)(color, style.line, highlightState);
    const fitLineThemeStyle = {
        ...style.fit.line,
        strokeWidth: style.line.strokeWidth,
        dimmed: style.line.dimmed,
        focused: style.line.focused,
    };
    const fitLineStyle = (0, line_1.buildLineStyles)(color, fitLineThemeStyle, highlightState);
    (0, path_1.renderLinePaths)(ctx, transform, lines, lineStyle, fitLineStyle, clippedRanges, clippings, shouldClip && style.fit.line.visible);
}
//# sourceMappingURL=areas.js.map