"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipInfo = void 0;
const get_active_value_1 = require("./get_active_value");
const get_bullet_spec_1 = require("./get_bullet_spec");
const create_selector_1 = require("../../../state/create_selector");
const common_1 = require("../../../utils/common");
const spec_1 = require("../spec");
exports.getTooltipInfo = (0, create_selector_1.createCustomCachedSelector)([get_active_value_1.getActiveValue, get_bullet_spec_1.getBulletSpec], (activeValue, spec) => {
    if (!activeValue)
        return;
    const useHighlighter = false;
    const highlightMargin = 2;
    const valueLabels = (0, spec_1.mergeValueLabels)(spec.valueLabels);
    const activeDatum = activeValue.panel.datum;
    const tooltipInfo = {
        header: null,
        values: [],
    };
    tooltipInfo.values.push({
        label: valueLabels.active,
        value: activeValue.value,
        color: activeValue.color,
        isHighlighted: false,
        seriesIdentifier: {
            specId: 'bullet',
            key: 'active',
        },
        isVisible: true,
        formattedValue: activeDatum.valueFormatter(activeValue.snapValue),
    });
    const isHighlighted = useHighlighter
        ? (0, common_1.isBetween)(activeValue.pixelValue - highlightMargin, activeValue.pixelValue + highlightMargin)
        : () => false;
    tooltipInfo.values.push({
        label: valueLabels.value,
        value: activeDatum.value,
        color: activeValue.panel.colorScale(activeDatum.value).hex(),
        isHighlighted: isHighlighted(activeValue.panel.scale(activeDatum.value)),
        seriesIdentifier: {
            specId: 'bullet',
            key: 'value',
        },
        isVisible: true,
        formattedValue: activeDatum.valueFormatter(activeDatum.value),
    });
    if (activeDatum.target) {
        tooltipInfo.values.push({
            label: valueLabels.target,
            value: activeDatum.target,
            color: activeValue.panel.colorScale(activeDatum.target).hex(),
            isHighlighted: isHighlighted(activeValue.panel.scale(activeDatum.target)),
            seriesIdentifier: {
                specId: 'bullet',
                key: 'target',
            },
            isVisible: true,
            formattedValue: activeDatum.valueFormatter(activeDatum.target),
        });
    }
    return tooltipInfo;
});
//# sourceMappingURL=get_tooltip_info.js.map