import { createAggregatedClient } from "@smithy/smithy-client";
import { BedrockAgentRuntimeClient } from "./BedrockAgentRuntimeClient";
import { DeleteAgentMemoryCommand, } from "./commands/DeleteAgentMemoryCommand";
import { GenerateQueryCommand, } from "./commands/GenerateQueryCommand";
import { GetAgentMemoryCommand, } from "./commands/GetAgentMemoryCommand";
import { InvokeAgentCommand } from "./commands/InvokeAgentCommand";
import { InvokeFlowCommand } from "./commands/InvokeFlowCommand";
import { InvokeInlineAgentCommand, } from "./commands/InvokeInlineAgentCommand";
import { OptimizePromptCommand, } from "./commands/OptimizePromptCommand";
import { RerankCommand } from "./commands/RerankCommand";
import { RetrieveAndGenerateCommand, } from "./commands/RetrieveAndGenerateCommand";
import { RetrieveAndGenerateStreamCommand, } from "./commands/RetrieveAndGenerateStreamCommand";
import { RetrieveCommand } from "./commands/RetrieveCommand";
const commands = {
    DeleteAgentMemoryCommand,
    GenerateQueryCommand,
    GetAgentMemoryCommand,
    InvokeAgentCommand,
    InvokeFlowCommand,
    InvokeInlineAgentCommand,
    OptimizePromptCommand,
    RerankCommand,
    RetrieveCommand,
    RetrieveAndGenerateCommand,
    RetrieveAndGenerateStreamCommand,
};
export class BedrockAgentRuntime extends BedrockAgentRuntimeClient {
}
createAggregatedClient(commands, BedrockAgentRuntime);
