"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  toUIMessageStream: () => toUIMessageStream
});
module.exports = __toCommonJS(src_exports);

// src/stream-callbacks.ts
function createCallbacksTransformer(callbacks = {}) {
  let aggregatedResponse = "";
  return new TransformStream({
    async start() {
      if (callbacks.onStart) await callbacks.onStart();
    },
    async transform(message, controller) {
      controller.enqueue(message);
      aggregatedResponse += message;
      if (callbacks.onToken) await callbacks.onToken(message);
      if (callbacks.onText && typeof message === "string") {
        await callbacks.onText(message);
      }
    },
    async flush() {
      if (callbacks.onFinal) {
        await callbacks.onFinal(aggregatedResponse);
      }
    }
  });
}

// src/langchain-adapter.ts
function toUIMessageStream(stream, callbacks) {
  return stream.pipeThrough(
    new TransformStream({
      transform: async (value, controller) => {
        var _a;
        if (typeof value === "string") {
          controller.enqueue(value);
          return;
        }
        if ("event" in value) {
          if (value.event === "on_chat_model_stream") {
            forwardAIMessageChunk(
              (_a = value.data) == null ? void 0 : _a.chunk,
              controller
            );
          }
          return;
        }
        forwardAIMessageChunk(value, controller);
      }
    })
  ).pipeThrough(createCallbacksTransformer(callbacks)).pipeThrough(
    new TransformStream({
      start: async (controller) => {
        controller.enqueue({ type: "text-start", id: "1" });
      },
      transform: async (chunk, controller) => {
        controller.enqueue({ type: "text-delta", delta: chunk, id: "1" });
      },
      flush: async (controller) => {
        controller.enqueue({ type: "text-end", id: "1" });
      }
    })
  );
}
function forwardAIMessageChunk(chunk, controller) {
  if (typeof chunk.content === "string") {
    controller.enqueue(chunk.content);
  } else {
    const content = chunk.content;
    for (const item of content) {
      if (item.type === "text") {
        controller.enqueue(item.text);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  toUIMessageStream
});
//# sourceMappingURL=index.js.map