"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VislibError = exports.NoResults = exports.InvalidLogScaleValues = exports.ContainerTooSmall = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable max-classes-per-file */

class VislibError extends _public.KbnError {
  constructor(message) {
    super(message);
  }
  displayToScreen(handler) {
    handler.error(this.message);
  }
}
exports.VislibError = VislibError;
class InvalidLogScaleValues extends VislibError {
  constructor() {
    super('Values less than 1 cannot be displayed on a log scale');
  }
}
exports.InvalidLogScaleValues = InvalidLogScaleValues;
class ContainerTooSmall extends VislibError {
  constructor() {
    super('This container is too small to render the visualization');
  }
}
exports.ContainerTooSmall = ContainerTooSmall;
class NoResults extends VislibError {
  constructor() {
    super(_i18n.i18n.translate('visTypeVislib.vislib.errors.noResultsFoundTitle', {
      defaultMessage: 'No results found'
    }));
  }
}
exports.NoResults = NoResults;