"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderXValues = orderXValues;
var _lodash = _interopRequireDefault(require("lodash"));
var _moment = _interopRequireDefault(require("moment"));
var _uniq_keys = require("./uniq_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Accepts a Kibana data object and returns
 * an array of x axis values.
 * values sorted by timestamp if isDate and Date Histogram agg
 * else values sorted by index
 */
function orderXValues(obj, orderBucketsBySum = false) {
  if (!_lodash.default.isObject(obj)) {
    throw new Error('orderXValues expects an object');
  }
  const uniqKeys = (0, _uniq_keys.getUniqKeys)(obj);
  const uniqKeysPairs = [...uniqKeys.entries()];
  const interval = _lodash.default.get(obj, 'ordered.interval');
  const dateInterval = _moment.default.isDuration(interval) ? interval : false;
  return (0, _lodash.default)(uniqKeysPairs).sortBy(function (d) {
    if (d[1].isDate || d[1].isOrdered) {
      return +d[0];
    }
    return orderBucketsBySum ? -d[1].sum : d[1].index;
  }).map(function (d, i, list) {
    if (!d[1].isNumber) return d[0];
    const val = +d[0];
    if (interval == null) return val;
    const gapEdge = parseFloat(_lodash.default.get(list, [i + 1, 0]));
    if (isNaN(gapEdge)) return val;
    const vals = [];
    let next = val;
    if (dateInterval) {
      next = (0, _moment.default)(val);
      while (next < gapEdge) {
        vals.push(next.valueOf());
        next.add(dateInterval);
      }
    } else {
      while (next < gapEdge) {
        vals.push(next);
        next += interval;
      }
    }
    return vals;
  }).flatten().value();
}