"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pointSeriesTooltipFormatter = pointSeriesTooltipFormatter;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _common = require("@kbn/field-formats-plugin/common");
var _percentage_mode_transform = require("../../percentage_mode_transform");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vislib/public/vislib/components/tooltip/_pointseries_tooltip_formatter.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function getMax(handler, config, isGauge) {
  let max;
  if (handler.pointSeries) {
    const series = handler.pointSeries.getSeries();
    const scale = series.getValueAxis().getScale();
    max = scale.domain()[1];
  } else {
    max = (0, _lodash.last)(config.get(isGauge ? 'gauge.colorsRange' : 'colorsRange', [{}])).to;
  }
  return max;
}
function pointSeriesTooltipFormatter() {
  return function tooltipFormatter({
    datum,
    data,
    config,
    handler
  }, uiSettings) {
    if (!datum) return '';
    const details = [];
    const isGauge = config.get('gauge', false);
    const chartType = config.get('type', undefined);
    const isPercentageMode = config.get(isGauge ? 'gauge.percentageMode' : 'percentageMode', false);
    const isSetColorRange = config.get('setColorRange', false);
    const currentSeries = data.series && data.series.find(serie => serie.rawId === datum.seriesId);
    const addDetail = (label, value) => details.push({
      label,
      value
    });
    if (datum.extraMetrics) {
      datum.extraMetrics.forEach(metric => {
        addDetail(metric.label, metric.value);
      });
    }

    // For goal and gauge we have only one value for x - '_all'. It doesn't have sense to show it
    if (datum.x !== null && datum.x !== undefined && !['goal', 'gauge'].includes(chartType)) {
      addDetail(data.xAxisLabel, data.xAxisFormatter(datum.x));
    }
    if (datum.y !== null && datum.y !== undefined) {
      let value = datum.yScale ? datum.yScale * datum.y : datum.y;
      if (isPercentageMode && !isSetColorRange) {
        const percentageFormatPattern = config.get(isGauge ? 'gauge.percentageFormatPattern' : 'percentageFormatPattern', uiSettings.get(_common.FORMATS_UI_SETTINGS.FORMAT_PERCENT_DEFAULT_PATTERN));
        value = (0, _percentage_mode_transform.getValueForPercentageMode)(value / getMax(handler, config, isGauge), percentageFormatPattern);
        addDetail(currentSeries.label, value);
      } else {
        addDetail(currentSeries.label, currentSeries.yAxisFormatter(value));
      }
    }
    if (datum.z !== null && datum.z !== undefined) {
      addDetail(currentSeries.zLabel, currentSeries.zAxisFormatter(datum.z));
    }
    if (datum.series && datum.parent) {
      const dimension = datum.parent;
      addDetail(dimension.title, datum.series);
    }
    if (datum.tableRaw) {
      addDetail(datum.tableRaw.title, datum.tableRaw.value);
    }
    return (0, _server.renderToStaticMarkup)(/*#__PURE__*/_react.default.createElement("table", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("tbody", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }, details.map((detail, index) => /*#__PURE__*/_react.default.createElement("tr", {
      key: index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("td", {
      className: "visTooltip__label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "visTooltip__labelContainer",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }, detail.label)), /*#__PURE__*/_react.default.createElement("td", {
      className: "visTooltip__value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "visTooltip__valueContainer",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 17
      }
    }, detail.value, detail.percent && /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 38
      }
    }, " (", detail.percent, ")"))))))));
  };
}