"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVislibVisController = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _jquery = _interopRequireDefault(require("jquery"));
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _legend = require("./vislib/components/legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vislib/public/vis_controller.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const legendClassName = {
  top: 'vislib--legend-top',
  bottom: 'vislib--legend-bottom',
  left: 'vislib--legend-left',
  right: 'vislib--legend-right'
};
const createVislibVisController = (core, charts) => {
  return class VislibVisController {
    constructor(el) {
      (0, _defineProperty2.default)(this, "removeListeners", void 0);
      (0, _defineProperty2.default)(this, "unmountLegend", void 0);
      (0, _defineProperty2.default)(this, "legendRef", void 0);
      (0, _defineProperty2.default)(this, "container", void 0);
      (0, _defineProperty2.default)(this, "chartEl", void 0);
      (0, _defineProperty2.default)(this, "legendEl", void 0);
      (0, _defineProperty2.default)(this, "vislibVis", void 0);
      this.el = el;
      this.el = el;
      this.legendRef = /*#__PURE__*/_react.default.createRef();

      // vis mount point
      this.container = document.createElement('div');
      this.container.className = 'vislib';
      this.el.appendChild(this.container);

      // chart mount point
      this.chartEl = document.createElement('div');
      this.chartEl.className = 'vislib__chart';
      this.container.appendChild(this.chartEl);

      // legend mount point
      this.legendEl = document.createElement('div');
      this.legendEl.className = 'vislib__legend';
      this.container.appendChild(this.legendEl);
    }
    async render(esResponse, visParams, handlers, renderComplete) {
      if (this.vislibVis) {
        this.destroy(false);
      }

      // Used in functional tests to know when chart is loaded by type
      this.chartEl.dataset.vislibChartType = visParams.type;
      if (this.el.clientWidth === 0 || this.el.clientHeight === 0) {
        renderComplete === null || renderComplete === void 0 ? void 0 : renderComplete();
        return;
      }
      const {
        Vis: Vislib
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vislib/vis')));
      const {
        uiState,
        event: fireEvent,
        hasCompatibleActions
      } = handlers;
      this.vislibVis = new Vislib(this.chartEl, visParams, core, charts);
      this.vislibVis.on('brush', fireEvent);
      this.vislibVis.on('click', fireEvent);
      const [startServices] = await core.getStartServices();
      this.vislibVis.on('renderComplete', () => {
        // refreshing the legend after the chart is rendered.
        // this is necessary because some visualizations
        // provide data necessary for the legend only after a render cycle.
        if (this.showLegend(visParams) && _legend.CUSTOM_LEGEND_VIS_TYPES.includes(this.vislibVis.visConfigArgs.type)) {
          var _this$unmountLegend;
          (_this$unmountLegend = this.unmountLegend) === null || _this$unmountLegend === void 0 ? void 0 : _this$unmountLegend.call(this);
          this.mountLegend(startServices, esResponse, visParams, fireEvent, hasCompatibleActions, uiState);
        }
        renderComplete === null || renderComplete === void 0 ? void 0 : renderComplete();
      });
      this.removeListeners = () => {
        this.vislibVis.off('brush', fireEvent);
        this.vislibVis.off('click', fireEvent);
      };
      this.vislibVis.initVisConfig(esResponse, uiState);
      if (this.showLegend(visParams)) {
        (0, _jquery.default)(this.container).attr('class', (_i, cls) => {
          return cls.replace(/vislib--legend-\S+/g, '');
        }).addClass(legendClassName[visParams.legendPosition]);
        this.mountLegend(startServices, esResponse, visParams, fireEvent, hasCompatibleActions, uiState);
      }
      this.vislibVis.render(esResponse, uiState);
    }
    mountLegend(startServices, visData, visParams, fireEvent, hasCompatibleActions, uiState) {
      const {
        legendPosition
      } = visParams;
      this.unmountLegend = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_legend.VisLegend, {
        ref: this.legendRef,
        vislibVis: this.vislibVis,
        visData: visData,
        uiState: uiState,
        fireEvent: fireEvent,
        hasCompatibleActions: hasCompatibleActions,
        addLegend: this.showLegend(visParams),
        position: legendPosition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 9
        }
      }), startServices)(this.legendEl);
    }
    destroy(clearElement = true) {
      var _this$unmountLegend2;
      (_this$unmountLegend2 = this.unmountLegend) === null || _this$unmountLegend2 === void 0 ? void 0 : _this$unmountLegend2.call(this);
      if (clearElement) {
        this.el.innerHTML = '';
      }
      if (this.vislibVis) {
        var _this$removeListeners;
        (_this$removeListeners = this.removeListeners) === null || _this$removeListeners === void 0 ? void 0 : _this$removeListeners.call(this);
        this.vislibVis.destroy();
        delete this.vislibVis;
      }
    }
    showLegend(visParams) {
      var _visParams$addLegend;
      return (_visParams$addLegend = visParams.addLegend) !== null && _visParams$addLegend !== void 0 ? _visParams$addLegend : false;
    }
  };
};
exports.createVislibVisController = createVislibVisController;