"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToTermsParams = exports.convertToTermsColumn = void 0;
var _uuid = require("uuid");
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getOrderByWithAgg = (series, columns) => {
  if (series.terms_order_by === '_key') {
    return {
      orderBy: {
        type: 'alphabetical'
      }
    };
  }
  if (series.terms_order_by === '_count' || !series.terms_order_by) {
    return {
      orderBy: {
        type: 'custom'
      },
      orderAgg: {
        operationType: 'count',
        sourceField: 'document',
        columnId: (0, _uuid.v4)(),
        isBucketed: true,
        isSplit: false,
        dataType: 'number',
        params: {}
      }
    };
  }
  const orderAgg = columns.find(column => {
    if ((0, _column.isColumnWithMeta)(column)) {
      return column.meta.metricId === series.terms_order_by;
    }
    return false;
  });
  if (!orderAgg) {
    return null;
  }
  return {
    orderBy: {
      type: 'column',
      columnId: orderAgg.columnId
    },
    orderAgg: (0, _column.excludeMetaFromColumn)(orderAgg)
  };
};
const convertToTermsParams = (series, columns, secondaryFields) => {
  const orderDirection = series.terms_direction === 'asc' ? 'asc' : 'desc';
  const orderByWithAgg = getOrderByWithAgg(series, columns);
  if (orderByWithAgg === null) {
    return null;
  }
  return {
    size: series.terms_size ? Number(series.terms_size) : 10,
    ...(series.terms_include && {
      include: [series.terms_include]
    }),
    includeIsRegex: Boolean(series.terms_include),
    ...(series.terms_exclude && {
      exclude: [series.terms_exclude]
    }),
    excludeIsRegex: Boolean(series.terms_exclude),
    otherBucket: false,
    orderDirection,
    parentFormat: {
      id: 'terms'
    },
    ...orderByWithAgg,
    secondaryFields
  };
};
exports.convertToTermsParams = convertToTermsParams;
const convertToTermsColumn = (termFields, series, columns, dataView, isSplit = false, label) => {
  var _ref;
  const [baseField, ...secondaryFields] = termFields;
  const field = dataView.getFieldByName(baseField);
  if (!field) {
    return null;
  }
  const params = convertToTermsParams(series, columns, secondaryFields);
  if (!params) {
    return null;
  }
  return {
    columnId: (0, _uuid.v4)(),
    operationType: 'terms',
    dataType: (_ref = field.type) !== null && _ref !== void 0 ? _ref : undefined,
    sourceField: field.name,
    isBucketed: true,
    isSplit,
    label,
    params: {
      ...params,
      ...(0, _column.getFormat)(series)
    }
  };
};
exports.convertToTermsColumn = convertToTermsColumn;