"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarSeriesDecorator = BarSeriesDecorator;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _series_styles = require("../utils/series_styles");
var _charts2 = require("../model/charts");
var _constants = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/visualizations/views/timeseries/decorators/bar_decorator.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function BarSeriesDecorator({
  seriesId,
  seriesGroupId,
  name,
  data,
  hideInLegend,
  bars,
  color,
  stackAccessors,
  stackMode,
  xScaleType,
  yScaleType,
  timeZone,
  enableHistogramMode,
  sortIndex,
  y1AccessorFormat,
  y0AccessorFormat,
  tickFormat
}) {
  const id = seriesId;
  const groupId = seriesGroupId;
  const barSeriesStyle = (0, _series_styles.getBarStyles)(bars, color);
  const seriesSettings = {
    id,
    name,
    groupId,
    data,
    color,
    hideInLegend,
    xAccessor: _constants.X_ACCESSOR_INDEX,
    yAccessors: _constants.Y_ACCESSOR_INDEXES,
    y0Accessors: bars.mode === 'band' ? _constants.Y0_ACCESSOR_INDEXES : undefined,
    y1AccessorFormat,
    y0AccessorFormat,
    stackAccessors,
    stackMode,
    xScaleType,
    yScaleType,
    timeZone,
    enableHistogramMode,
    sortIndex,
    tickFormat,
    ...barSeriesStyle
  };
  if (enableHistogramMode) {
    seriesSettings.histogramModeAlignment = 'center';
  }
  return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, (0, _extends2.default)({}, seriesSettings, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 10
    }
  }));
}
BarSeriesDecorator.propTypes = _charts2.ChartsEntities.BarChart;
BarSeriesDecorator.defaultProps = {
  yScaleType: _charts.ScaleType.Linear,
  xScaleType: _charts.ScaleType.Time
};