"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Gauge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _set_is_reversed = require("../../lib/set_is_reversed");
var _last_value_utils = require("../../../../common/last_value_utils");
var _get_value_by = require("../lib/get_value_by");
var _gauge_vis = require("./gauge_vis");
var _calculate_coordinates = require("../lib/calculate_coordinates");
var _variables = require("./_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/visualizations/views/gauge.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * 1. Text is scaled using a matrix so all font sizes and related metrics
 *    are being calcuated from a percentage of the base font size of 100% (14px).
 */

const containerStyle = (0, _react2.css)`
  font-size: 100%; /* 1 */
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
`;
const metricsBaseStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: absolute;
  width: 100px;
  height: 100px;
  text-align: center;
  padding: ${euiTheme.size.s};
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
`;
const halfMetricsStyle = ({
  euiTheme
}) => (0, _react2.css)`
  height: 70px;
  padding: 0 ${euiTheme.size.m} ${euiTheme.size.s};
  justify-content: flex-end;
`;
const labelStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbTextColor};
  font-size: 0.5em; /* 1 */
  line-height: 1em; /* 1 */
  text-align: center;
  padding: 0 ${euiTheme.size.s} ${euiTheme.size.xs};

  .tvbVisGauge--reversed & {
    color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbTextColorReversed};
  }
`;
const valueStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbValueColor};
  font-size: 0.9em; /* 1 */
  line-height: 1em; /* 1 */
  text-align: center;
  /* make gauge value the target for pointer-events */
  pointer-events: all;

  .tvbVisGauge--reversed & {
    color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbValueColorReversed};
  }
`;
const additionalLabelStyle = ({
  euiTheme
}) => (0, _react2.css)`
  font-size: 0.4em; /* 1 */
  line-height: 1.2em; /* 1 */
  width: 100%;
  padding: 2px ${euiTheme.size.xs};
  color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbValueColor};

  .tvbVisGauge--reversed & {
    color: ${(0, _variables.getVisVariables)({
  euiTheme
}).tvbValueColorReversed};
  }
`;
const resizeStyle = (0, _react2.css)`
  position: relative;
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  /* disable gauge container pointer-events as it shouldn't be event target */
  pointer-events: none;
`;
class Gauge extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handledResize", false);
    this.state = {
      scale: 1,
      top: 0,
      left: 0,
      translateX: 1,
      translateY: 1
    };
    this.handleResize = this.handleResize.bind(this);
    this.checkResizeThrottled = _lodash.default.throttle(() => {
      const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
      if (newState && this.state && !_lodash.default.isEqual(newState, this.state)) {
        this.handleResize();
      }
    }, 200);
  }
  componentWillUnmount() {
    clearTimeout(this.timeout);
  }
  componentDidMount() {
    this.handleResize(true);
  }
  handleResize() {
    // Bingo!
    const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
    this.setState(newState);
    this.handledResize = true;
  }
  render() {
    const {
      metric,
      type,
      initialRender
    } = this.props;
    const {
      scale,
      translateX,
      translateY
    } = this.state;
    const value = (0, _last_value_utils.getLastValue)(metric === null || metric === void 0 ? void 0 : metric.data);
    const max = metric && (0, _get_value_by.getValueBy)('max', metric.data) || 1;
    const formatter = metric && (metric.tickFormatter || metric.formatter) || this.props.tickFormatter || (v => v);
    const title = metric && metric.label || '';
    const innerCSS = (0, _react2.css)`
      top: ${this.state.top || 0}px;
      left: ${this.state.left || 0}px;
      transform: matrix(${scale}, 0, 0, ${scale}, ${translateX}, ${translateY});
      z-index: 1;
    `;
    const gaugeProps = {
      value,
      reversed: (0, _set_is_reversed.isBackgroundDark)(this.props.backgroundColor),
      gaugeLine: this.props.gaugeLine,
      innerLine: this.props.innerLine,
      innerColor: this.props.innerColor,
      max: this.props.max || max,
      color: metric && metric.color || '#8ac336',
      type,
      initialRender
    };
    let metrics;
    let additionalLabel;
    if (this.props.additionalLabel) {
      additionalLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__additionalLabel",
        css: [(0, _eui.euiTextTruncate)(), additionalLabelStyle],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 9
        }
      }, this.props.additionalLabel);
    }
    if (type === 'half') {
      metrics = /*#__PURE__*/_react.default.createElement("div", {
        css: [innerCSS, metricsBaseStyle, halfMetricsStyle],
        className: "tvbVisHalfGauge__metrics",
        ref: el => this.inner = el,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__label",
        css: labelStyle,
        ref: "title",
        "data-test-subj": "gaugeLabel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, title), /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__value",
        css: valueStyle,
        style: this.props.valueColor ? {
          color: this.props.valueColor
        } : {},
        ref: "label",
        "data-test-subj": "gaugeValue",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: formatter(value)
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 13
        }
      })), additionalLabel);
    } else {
      metrics = /*#__PURE__*/_react.default.createElement("div", {
        css: [innerCSS, metricsBaseStyle],
        className: "tvbVisCircleGauge__metrics",
        ref: el => this.inner = el,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__value",
        style: this.props.valueColor ? {
          color: this.props.valueColor
        } : {},
        ref: "label",
        "data-test-subj": "gaugeValue",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: formatter(value)
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisGauge__label",
        css: labelStyle,
        ref: "title",
        "data-test-subj": "gaugeLabel",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }, title), additionalLabel);
    }
    const classes = (0, _classnames.default)({
      tvbVisHalfGauge: type === 'half',
      tvbVisCircleGauge: type === 'circle',
      'tvbVisGauge--reversed': (0, _set_is_reversed.isBackgroundInverted)(this.props.backgroundColor)
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
      onResize: this.checkResizeThrottled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 7
      }
    }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
      className: classes,
      css: [containerStyle],
      ref: resizeRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.resize = el,
      className: `tvbVisGauge__resize`,
      css: resizeStyle,
      "data-test-subj": "tvbVisGaugeContainer",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    }, metrics, /*#__PURE__*/_react.default.createElement(_gauge_vis.GaugeVis, (0, _extends2.default)({}, gaugeProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 15
      }
    })))));
  }
}
exports.Gauge = Gauge;
Gauge.defaultProps = {
  type: 'half',
  innerLine: 2,
  gaugeLine: 10
};
Gauge.propTypes = {
  gaugeLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerColor: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  innerLine: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  max: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  metric: _propTypes.default.object,
  backgroundColor: _propTypes.default.string,
  type: _propTypes.default.oneOf(['half', 'circle']),
  valueColor: _propTypes.default.string,
  additionalLabel: _propTypes.default.string
};