"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TSVB_EDITOR_NAME = exports.EditorController = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _services = require("../services");
var _vis_editor_lazy = require("./components/vis_editor_lazy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/editor_controller.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const TSVB_EDITOR_NAME = exports.TSVB_EDITOR_NAME = 'tsvbEditor';
class EditorController {
  constructor(el, vis, eventEmitter, embeddableHandler) {
    this.el = el;
    this.vis = vis;
    this.eventEmitter = eventEmitter;
    this.embeddableHandler = embeddableHandler;
  }
  async render({
    timeRange,
    uiState,
    filters,
    query
  }) {
    const defaultIndexPattern = (await (0, _services.getDataViewsStart)().getDefault()) || undefined;
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, (0, _services.getCoreStart)(), {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_vis_editor_lazy.VisEditor, {
      config: (0, _services.getUISettings)(),
      vis: this.vis,
      timeRange: timeRange,
      embeddableHandler: this.embeddableHandler,
      eventEmitter: this.eventEmitter,
      uiState: uiState,
      filters: filters,
      query: query,
      defaultIndexPattern: defaultIndexPattern,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    })), this.el);
  }
  destroy() {
    (0, _reactDom.unmountComponentAtNode)(this.el);
  }
}
exports.EditorController = EditorController;