"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableSeriesConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/data-plugin/public");
var _data_format_picker = require("../../data_format_picker");
var _create_select_handler = require("../../lib/create_select_handler");
var _create_text_handler = require("../../lib/create_text_handler");
var _field_select = require("../../aggs/field_select");
var _yes_no = require("../../yes_no");
var _color_rules = require("../../color_rules");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_default_query_language = require("../../lib/get_default_query_language");
var _check_if_numeric_metric = require("../../lib/check_if_numeric_metric");
var _query_bar_wrapper = require("../../query_bar_wrapper");
var _enums = require("../../../../../common/enums");
var _check_ui_restrictions = require("../../../../../common/check_ui_restrictions");
var _errors = require("../../../../../common/errors");
var _common = require("../../../styles/common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_types/table/config.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TableSeriesConfigUi extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleAggregateByChange", selectedOptions => {
      this.props.onChange({
        aggregate_by: selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions[0]
      });
    });
    (0, _defineProperty2.default)(this, "handleSelectChange", (0, _create_select_handler.createSelectHandler)(this.props.onChange));
    (0, _defineProperty2.default)(this, "handleTextChange", (0, _create_text_handler.createTextHandler)(this.props.onChange));
    (0, _defineProperty2.default)(this, "changeModelFormatter", formatter => this.props.onChange({
      formatter
    }));
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    if (!model.color_rules || model.color_rules && model.color_rules.length === 0) {
      this.props.onChange({
        color_rules: [{
          id: (0, _uuid.v4)()
        }]
      });
    }
  }
  render() {
    var _model$filter, _model$filter2, _model$filter3;
    const defaults = {
      offset_time: '',
      value_template: '{{value}}'
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const htmlId = (0, _eui.htmlIdGenerator)();
    const functionOptions = [{
      label: _i18n.i18n.translate('visTypeTimeseries.table.sumLabel', {
        defaultMessage: 'Sum'
      }),
      value: 'sum'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.maxLabel', {
        defaultMessage: 'Max'
      }),
      value: 'max'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.minLabel', {
        defaultMessage: 'Min'
      }),
      value: 'min'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.avgLabel', {
        defaultMessage: 'Avg'
      }),
      value: 'mean'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.overallSumLabel', {
        defaultMessage: 'Overall Sum'
      }),
      value: 'overall_sum'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.overallMaxLabel', {
        defaultMessage: 'Overall Max'
      }),
      value: 'overall_max'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.overallMinLabel', {
        defaultMessage: 'Overall Min'
      }),
      value: 'overall_min'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.overallAvgLabel', {
        defaultMessage: 'Overall Avg'
      }),
      value: 'overall_avg'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.cumulativeSumLabel', {
        defaultMessage: 'Cumulative Sum'
      }),
      value: 'cumulative_sum'
    }];
    const selectedAggFuncOption = functionOptions.find(option => {
      return model.aggregate_function === option.value;
    });
    const isNumericMetric = (0, _check_if_numeric_metric.checkIfNumericMetric)((0, _lodash.last)(model.metrics), this.props.fields, this.props.indexPatternForQuery);
    const isKibanaIndexPattern = this.props.panel.use_kibana_indexes || this.props.indexPatternForQuery === '';
    const isFilterCannotBeApplied = ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.query) && !(0, _check_ui_restrictions.isConfigurationFeatureEnabled)('filter', this.props.uiRestrictions);
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _common.tsvbEditorRowStyles)(this.props.theme.euiTheme),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_data_format_picker.DataFormatPicker, {
      formatterValue: model.formatter,
      changeModelFormatter: this.changeModelFormatter,
      shouldIncludeDefaultOption: isKibanaIndexPattern,
      shouldIncludeNumberOptions: isNumericMetric,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('template'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.templateLabel",
        defaultMessage: "Template",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 17
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.templateHelpText",
        defaultMessage: "eg.{templateExample}",
        values: {
          templateExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 164,
              columnNumber: 48
            }
          }, '{{value}}/s')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 19
        }
      })),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      onChange: this.handleTextChange('value_template'),
      value: model.value_template,
      disabled: model.formatter === _enums.DATA_FORMATTERS.DEFAULT,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('filterInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.filterLabel",
        defaultMessage: "Filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 17
        }
      }),
      isInvalid: isFilterCannotBeApplied,
      error: _errors.filterCannotBeAppliedErrorMessage,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: (model === null || model === void 0 ? void 0 : (_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: (model === null || model === void 0 ? void 0 : (_model$filter3 = model.filter) === null || _model$filter3 === void 0 ? void 0 : _model$filter3.query) || ''
      },
      isInvalid: isFilterCannotBeApplied,
      onChange: filter => this.props.onChange({
        filter
      }),
      indexPatterns: [this.props.indexPatternForQuery],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.showTrendArrowsLabel', {
        defaultMessage: 'Show trend arrows?'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.trend_arrows,
      name: "trend_arrows",
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      "data-test-subj": "tsvbAggregateBySelect",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.fieldLabel",
        defaultMessage: "Field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 17
        }
      }),
      fields: this.props.fields,
      indexPattern: this.props.panel.index_pattern,
      value: model.aggregate_by,
      onChange: this.handleAggregateByChange,
      fullWidth: true,
      restrict: [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.BOOLEAN, _public.KBN_FIELD_TYPES.DATE, _public.KBN_FIELD_TYPES.IP, _public.KBN_FIELD_TYPES.STRING],
      uiRestrictions: this.props.uiRestrictions,
      type: _enums.BUCKET_TYPES.TERMS,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('aggregateFunctionInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.aggregateFunctionLabel",
        defaultMessage: "Aggregate function",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 17
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": "tsvbAggregateFunctionCombobox",
      options: functionOptions,
      selectedOptions: selectedAggFuncOption ? [selectedAggFuncOption] : [],
      onChange: this.handleSelectChange('aggregate_function'),
      singleSelection: {
        asPlainText: true
      },
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.colorRulesLabel",
      defaultMessage: "Color rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_color_rules.ColorRules, {
      primaryName: "text",
      primaryVarName: "text",
      hideSecondary: true,
      model: model,
      onChange: this.props.onChange,
      name: "color_rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 9
      }
    }));
  }
}
TableSeriesConfigUi.propTypes = {
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
  uiRestrictions: _propTypes.default.object
};
const TableSeriesConfig = exports.TableSeriesConfig = (0, _eui.withEuiTheme)(TableSeriesConfigUi);