"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownSeries = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _add_delete_buttons = require("../../add_delete_buttons");
var _series_config = require("../../series_config");
var _split = require("../../split");
var _create_text_handler = require("../../lib/create_text_handler");
var _aggs = require("../../aggs/aggs");
var _series_drag_handler = require("../../series_drag_handler");
var _common = require("../../../styles/common.styles");
var _series_editor = require("../../_series_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_types/markdown/series.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function MarkdownSeriesUi(props) {
  const {
    panel,
    fields,
    onAdd,
    onChange,
    onDelete,
    disableDelete,
    disableAdd,
    selectedTab,
    visible,
    intl,
    name,
    uiRestrictions
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const seriesBodyStyles = (0, _series_editor.useSeriesBodyStyles)();
  const defaults = {
    label: '',
    var_name: ''
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const handleChange = (0, _create_text_handler.createTextHandler)(onChange);
  let caretIcon = 'arrowDown';
  if (!visible) caretIcon = 'arrowRight';
  let body = null;
  if (visible) {
    let seriesBody;
    if (selectedTab === 'metrics') {
      seriesBody = /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_aggs.Aggs, {
        onChange: props.onChange,
        fields: fields,
        panel: panel,
        model: model,
        name: name,
        uiRestrictions: uiRestrictions,
        dragHandleProps: props.dragHandleProps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement("div", {
        css: [(0, _common.tsvbEditorRowStyles)(euiTheme), (0, _common.aggRowSplitStyles)(euiTheme)],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_split.Split, {
        onChange: props.onChange,
        fields: fields,
        panel: panel,
        model: model,
        uiRestrictions: uiRestrictions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 13
        }
      })));
    } else {
      seriesBody = /*#__PURE__*/_react.default.createElement(_series_config.SeriesConfig, {
        fields: props.fields,
        panel: panel,
        model: props.model,
        onChange: props.onChange,
        indexPatternForQuery: props.indexPatternForQuery,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 9
        }
      });
    }
    body = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbSeries__body",
      css: seriesBodyStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === 'metrics',
      onClick: () => props.switchTab('metrics'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdown.dataTab.metricsButtonLabel",
      defaultMessage: "Metrics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      "data-test-subj": "seriesOptions",
      isSelected: selectedTab === 'options',
      onClick: () => props.switchTab('options'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.markdown.optionsTab.optionsButtonLabel",
      defaultMessage: "Options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }))), seriesBody);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `${props.className}`,
    style: props.style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: caretIcon,
    color: "text",
    onClick: props.toggleVisible,
    "aria-label": intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.toggleEditorAriaLabel',
      defaultMessage: 'Toggle series editor'
    }),
    "aria-expanded": props.visible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: handleChange('label'),
    placeholder: intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.labelPlaceholder',
      defaultMessage: 'Label'
    }),
    value: model.label,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: handleChange('var_name'),
    placeholder: intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.variableNamePlaceholder',
      defaultMessage: 'Variable name'
    }),
    value: model.var_name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_series_drag_handler.SeriesDragHandler, {
    dragHandleProps: props.dragHandleProps,
    hideDragHandler: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    addTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.addSeriesTooltip',
      defaultMessage: 'Add series'
    }),
    deleteTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.deleteSeriesTooltip',
      defaultMessage: 'Delete series'
    }),
    cloneTooltip: intl.formatMessage({
      id: 'visTypeTimeseries.markdown.editor.cloneSeriesTooltip',
      defaultMessage: 'Clone series'
    }),
    onDelete: onDelete,
    onClone: props.onClone,
    onAdd: onAdd,
    disableDelete: disableDelete,
    disableAdd: disableAdd,
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }))), body);
}
MarkdownSeriesUi.propTypes = {
  className: _propTypes.default.string,
  colorPicker: _propTypes.default.bool,
  disableAdd: _propTypes.default.bool,
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  name: _propTypes.default.string,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onClone: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  selectedTab: _propTypes.default.string,
  style: _propTypes.default.object,
  switchTab: _propTypes.default.func,
  toggleVisible: _propTypes.default.func,
  visible: _propTypes.default.bool,
  uiRestrictions: _propTypes.default.object,
  dragHandleProps: _propTypes.default.object,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string])
};
const MarkdownSeries = exports.MarkdownSeries = (0, _i18nReact.injectI18n)(MarkdownSeriesUi);