"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TimeseriesVisualization;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _react2 = require("@emotion/react");
var _timeseries_loading = require("./timeseries_loading");
var _vis_types = require("./vis_types");
var _vis_data_utils = require("../../../common/vis_data_utils");
var _convert_series_to_datatable = require("./lib/convert_series_to_datatable");
var _get_click_filter_data = require("./lib/get_click_filter_data");
var _constants = require("../visualizations/constants");
var _last_value_mode_indicator = require("./last_value_mode_indicator");
var _get_interval = require("./lib/get_interval");
var _constants2 = require("../../../common/constants");
var _enums = require("../../../common/enums");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
var _services = require("../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/timeseries_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TimeseriesVisualization({
  visData,
  model,
  handlers,
  uiState,
  getConfig,
  syncColors,
  syncCursor,
  syncTooltips,
  initialRender
}) {
  var _ref, _visData$model$id, _model$interval;
  const [indexPattern, setIndexPattern] = (0, _react.useState)(null);
  const [palettesService, setPalettesService] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (0, _services.getCharts)().palettes.getPalettes().then(paletteRegistry => setPalettesService(paletteRegistry));
  }, []);
  (0, _react.useEffect)(() => {
    (0, _index_patterns_utils.fetchIndexPattern)(model.index_pattern, (0, _services.getDataViewsStart)()).then(fetchedIndexPattern => setIndexPattern(fetchedIndexPattern.indexPattern));
  }, [model.index_pattern]);
  const onBrush = (0, _react.useCallback)(async (gte, lte, series) => {
    let event;
    // trigger applyFilter if no index pattern found, url drilldowns are supported only
    // for the index pattern mode
    if (indexPattern) {
      const tables = indexPattern ? await (0, _convert_series_to_datatable.convertSeriesToDataTable)(model, series, indexPattern) : null;
      const table = tables === null || tables === void 0 ? void 0 : tables[model.series[0].id];
      const range = [parseInt(gte, 10), parseInt(lte, 10)];
      event = {
        data: {
          table,
          column: _constants.X_ACCESSOR_INDEX,
          range,
          timeFieldName: indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.timeFieldName
        },
        name: 'brush'
      };
    } else {
      event = {
        name: 'applyFilter',
        data: {
          timeFieldName: '*',
          filters: [{
            query: {
              range: {
                '*': {
                  gte,
                  lte
                }
              }
            }
          }]
        }
      };
    }
    handlers.event(event);
  }, [handlers, indexPattern, model]);
  const handleFilterClick = (0, _react.useCallback)(async (series, points) => {
    // it should work only if index pattern is found
    if (!indexPattern) return;
    const tables = indexPattern ? await (0, _convert_series_to_datatable.convertSeriesToDataTable)(model, series, indexPattern) : null;
    if (!tables) return;
    const data = (0, _get_click_filter_data.getClickFilterData)(points, tables, model);
    const event = {
      name: 'filter',
      data: {
        data,
        negate: false,
        timeFieldName: indexPattern.timeFieldName
      }
    };
    handlers.event(event);
  }, [handlers, indexPattern, model]);
  const handleUiState = (0, _react.useCallback)((field, value) => {
    uiState.set(field, value);
    // reload visualization because data might need to be re-fetched
    uiState.emit('reload');
  }, [uiState]);
  const VisComponent = _vis_types.TimeseriesVisTypes[model.type];
  const isLastValueMode = !model.time_range_mode || model.time_range_mode === _enums.TIME_RANGE_DATA_MODES.LAST_VALUE;
  const shouldDisplayLastValueIndicator = isLastValueMode && !model.hide_last_value_indicator && model.type !== _enums.PANEL_TYPES.TIMESERIES;
  const [firstSeries] = (_ref = (0, _vis_data_utils.isVisTableData)(visData) ? visData.series : (_visData$model$id = visData[model.id]) === null || _visData$model$id === void 0 ? void 0 : _visData$model$id.series) !== null && _ref !== void 0 ? _ref : [];
  if (!VisComponent || palettesService === null || indexPattern === null) {
    return /*#__PURE__*/_react.default.createElement(_timeseries_loading.TimeseriesLoading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, shouldDisplayLastValueIndicator && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "tvbLastValueIndicator",
    css: (0, _react2.css)`
            align-self: flex-end;
          `,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_last_value_mode_indicator.LastValueModeIndicator, {
    seriesData: firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.data,
    ignoreDaylightTime: model.ignore_daylight_time,
    panelInterval: (0, _get_interval.getInterval)(visData, model),
    modelInterval: (_model$interval = model.interval) !== null && _model$interval !== void 0 ? _model$interval : _constants2.AUTO_INTERVAL,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement("div", {
      className: "visChart__spinner",
      css: _public.visContainerStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(VisComponent, {
    getConfig: getConfig,
    model: model,
    visData: visData,
    uiState: uiState,
    onBrush: onBrush,
    initialRender: initialRender,
    onFilterClick: handleFilterClick,
    onUiState: handleUiState,
    syncColors: syncColors,
    syncTooltips: syncTooltips,
    syncCursor: syncCursor,
    palettesService: palettesService,
    indexPattern: indexPattern,
    fieldFormatMap: indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fieldFormatMap,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }))));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;