"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitByFilter = void 0;
var _group_by_select = require("./group_by_select");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_default_query_language = require("../lib/get_default_query_language");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/splits/filter.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const RESET_STATE = {
  filter: undefined
};
const SplitByFilter = props => {
  const {
    onChange,
    uiRestrictions,
    indexPattern
  } = props;
  const defaults = {
    filter: {
      language: (0, _get_default_query_language.getDefaultQueryLanguage)(),
      query: ''
    }
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const htmlId = (0, _eui.htmlIdGenerator)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('group'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.filter.groupByLabel",
      defaultMessage: "Group by",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_group_by_select.GroupBySelect, {
    value: model.split_mode,
    onChange: ([{
      value: newSplitMode = null
    }]) => {
      onChange({
        split_mode: newSplitMode,
        ...RESET_STATE
      });
    },
    uiRestrictions: uiRestrictions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('query'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.filter.queryStringLabel",
      defaultMessage: "Query string",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
    query: {
      language: model.filter.language || (0, _get_default_query_language.getDefaultQueryLanguage)(),
      query: model.filter.query || ''
    },
    onChange: filter => onChange({
      filter
    }),
    indexPatterns: [indexPattern],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))));
};
exports.SplitByFilter = SplitByFilter;
SplitByFilter.propTypes = {
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  uiRestrictions: _propTypes.default.object,
  indexPatterns: _propTypes.default.string
};