"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Split = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _lodash = require("lodash");
var _terms = require("./splits/terms");
var _filter = require("./splits/filter");
var _filters = require("./splits/filters");
var _everything = require("./splits/everything");
var _unsupported_split = require("./splits/unsupported_split");
var _check_ui_restrictions = require("../../../common/check_ui_restrictions");
var _get_default_query_language = require("./lib/get_default_query_language");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/split.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SPLIT_MODES = {
  FILTERS: 'filters',
  FILTER: 'filter',
  TERMS: 'terms',
  EVERYTHING: 'everything'
};
class Split extends _react.Component {
  UNSAFE_componentWillReceiveProps(nextProps) {
    const {
      model
    } = nextProps;
    if (model.split_mode === 'filters' && !model.split_filters) {
      this.props.onChange({
        split_filters: [{
          color: model.color,
          id: (0, _uuid.v4)(),
          filter: {
            query: '',
            language: (0, _get_default_query_language.getDefaultQueryLanguage)()
          }
        }]
      });
    }
  }
  getComponent(splitMode, uiRestrictions) {
    if (!(0, _check_ui_restrictions.isGroupByFieldsEnabled)(splitMode, uiRestrictions)) {
      return _unsupported_split.SplitUnsupported;
    }
    switch (splitMode) {
      case SPLIT_MODES.TERMS:
        return _terms.SplitByTerms;
      case SPLIT_MODES.FILTER:
        return _filter.SplitByFilter;
      case SPLIT_MODES.FILTERS:
        return _filters.SplitByFilters;
      default:
        return _everything.SplitByEverything;
    }
  }
  render() {
    const {
      model,
      panel,
      uiRestrictions,
      seriesQuantity
    } = this.props;
    const indexPattern = model.override_index_pattern ? model.series_index_pattern : panel.index_pattern;
    const splitMode = (0, _lodash.get)(this.props, 'model.split_mode', SPLIT_MODES.EVERYTHING);
    const Component = this.getComponent(splitMode, uiRestrictions);
    return /*#__PURE__*/_react.default.createElement(Component, {
      model: model,
      indexPattern: indexPattern,
      fields: this.props.fields,
      onChange: this.props.onChange,
      uiRestrictions: uiRestrictions,
      seriesQuantity: seriesQuantity,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    });
  }
}
exports.Split = Split;
Split.propTypes = {
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  panel: _propTypes.default.object,
  seriesQuantity: _propTypes.default.object
};