"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _re_id_series = require("./lib/re_id_series");
var _series = require("./series");
var _collection_actions = require("./lib/collection_actions");
var _new_series_fn = require("./lib/new_series_fn");
var _eui = require("@elastic/eui");
var _reorder = require("./lib/reorder");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/series_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DROPPABLE_ID = 'series_editor_dnd';
const styles = ({
  euiTheme
}) => (0, _react2.css)`
  margin-bottom: ${euiTheme.size.base};
  padding: ${euiTheme.size.s};
`;
class SeriesEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "handleClone", series => {
      const newSeries = (0, _re_id_series.reIdSeries)(series);
      _collection_actions.handleAdd.call(null, this.props, () => newSeries);
    });
    (0, _defineProperty2.default)(this, "sortHandler", ({
      destination,
      source
    }) => {
      const canSort = destination && source;
      if (canSort) {
        const sortFunction = this.getSortFunction({
          destination,
          source
        });
        sortFunction({
          destination,
          source
        });
      }
    });
    (0, _defineProperty2.default)(this, "getSortFunction", ({
      destination,
      source
    }) => destination.droppableId === source.droppableId && source.droppableId === DROPPABLE_ID ? this.sortSeries : this.sortAggregations);
    (0, _defineProperty2.default)(this, "sortSeries", ({
      destination,
      source
    }) => {
      this.props.onChange({
        series: (0, _reorder.reorder)([...this.props.model.series], source.index, destination.index)
      });
    });
    (0, _defineProperty2.default)(this, "sortAggregations", ({
      destination,
      source
    }) => {
      const extractId = ({
        droppableId
      }) => droppableId.split(':')[1];
      const id = extractId(source);
      const canSort = id === extractId(destination);
      if (canSort) {
        const model = [...this.props.model.series];
        const series = (0, _lodash.find)(model, {
          id
        });
        series.metrics = (0, _reorder.reorder)([...series.metrics], source.index, destination.index);
        this.props.onChange({
          series: model
        });
      }
    });
    (0, _defineProperty2.default)(this, "handleSeriesChange", doc => {
      (0, _collection_actions.handleChange)(this.props, doc);
    });
  }
  render() {
    const {
      limit,
      model,
      name,
      fields,
      colorPicker
    } = this.props;
    const list = model[name].filter((val, index) => index < (limit || Infinity));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
      onDragEnd: this.sortHandler,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
      droppableId: DROPPABLE_ID,
      spacing: "l",
      type: "MACRO",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 9
      }
    }, list.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
      spacing: "m",
      key: row.id,
      index: idx,
      customDragHandle: true,
      draggableId: `${DROPPABLE_ID}:${row.id}`,
      disableInteractiveElementBlocking: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, provided => /*#__PURE__*/_react.default.createElement(_series.Series, {
      className: "tvbSeriesEditor",
      css: styles,
      colorPicker: colorPicker,
      disableAdd: model[name].length >= limit,
      disableDelete: model[name].length < 2,
      fields: fields,
      onAdd: () => (0, _collection_actions.handleAdd)(this.props, _new_series_fn.newSeriesFn),
      onChange: this.handleSeriesChange,
      onClone: () => this.handleClone(row),
      onDelete: () => (0, _collection_actions.handleDelete)(this.props, row),
      model: row,
      panel: model,
      dragHandleProps: provided.dragHandleProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    })))));
  }
}
exports.SeriesEditor = SeriesEditor;
SeriesEditor.defaultProps = {
  name: 'series',
  limit: Infinity,
  colorPicker: true
};
SeriesEditor.propTypes = {
  colorPicker: _propTypes.default.bool,
  fields: _propTypes.default.object,
  limit: _propTypes.default.number,
  model: _propTypes.default.object,
  name: _propTypes.default.string,
  onChange: _propTypes.default.func
};