"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesConfig = void 0;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _data_format_picker = require("./data_format_picker");
var _create_text_handler = require("./lib/create_text_handler");
var _check_if_numeric_metric = require("./lib/check_if_numeric_metric");
var _yes_no = require("./yes_no");
var _index_pattern = require("./index_pattern");
var _series_config_query_bar_with_ignore_global_filter = require("./series_config_query_bar_with_ignore_global_filter");
var _enums = require("../../../common/enums");
var _common = require("../styles/common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/series_config.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeriesConfig = props => {
  const defaults = {
    offset_time: '',
    value_template: '{{value}}'
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const handleTextChange = (0, _create_text_handler.createTextHandler)(props.onChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  const seriesIndexPattern = props.model.override_index_pattern ? props.model.series_index_pattern : props.indexPatternForQuery;
  const changeModelFormatter = (0, _react.useCallback)(formatter => props.onChange({
    formatter
  }), [props]);
  const isNumericMetric = (0, _react.useMemo)(() => (0, _check_if_numeric_metric.checkIfNumericMetric)((0, _lodash.last)(model.metrics), props.fields, seriesIndexPattern), [model.metrics, props.fields, seriesIndexPattern]);
  const isKibanaIndexPattern = props.panel.use_kibana_indexes || seriesIndexPattern === '';
  const {
    indexPatternForQuery,
    onChange
  } = props;
  const onChangeOverride = (0, _react.useCallback)(partialState => {
    const stateUpdate = {
      ...partialState
    };
    const isEnabling = partialState.override_index_pattern;
    if (isEnabling && !model.series_index_pattern) {
      stateUpdate.series_index_pattern = indexPatternForQuery;
    }
    onChange(stateUpdate);
  }, [model.series_index_pattern, indexPatternForQuery, onChange]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _common.tsvbEditorRowStyles)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_data_format_picker.DataFormatPicker, {
    formatterValue: model.formatter,
    changeModelFormatter: changeModelFormatter,
    shouldIncludeDefaultOption: isKibanaIndexPattern,
    shouldIncludeNumberOptions: isNumericMetric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('template'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.templateLabel",
      defaultMessage: "Template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 15
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.templateHelpText",
      defaultMessage: "eg. {templateExample}",
      values: {
        templateExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 46
          }
        }, '{{value}}/s')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 17
      }
    })),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleTextChange('value_template'),
    value: model.value_template,
    disabled: model.formatter === _enums.DATA_FORMATTERS.DEFAULT,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_series_config_query_bar_with_ignore_global_filter.SeriesConfigQueryBarWithIgnoreGlobalFilter, {
    model: model,
    onChange: props.onChange,
    panel: props.panel,
    indexPatternForQuery: seriesIndexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('offsetSeries'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.offsetSeriesTimeLabel",
      defaultMessage: "Offset series time by (1m, 1h, 1w, 1d)",
      description: "1m, 1h, 1w and 1d are required values and must not be translated.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "offsetTimeSeries",
    onChange: handleTextChange('offset_time'),
    value: model.offset_time,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.seriesConfig.overrideDataViewLabel', {
      defaultMessage: 'Override data view?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.override_index_pattern,
    name: "override_index_pattern",
    onChange: onChangeOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
    baseIndexPattern: indexPatternForQuery,
    onChange: props.onChange,
    model: props.model,
    fields: props.fields,
    prefix: "series_",
    disabled: !model.override_index_pattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }))));
};
exports.SeriesConfig = SeriesConfig;
SeriesConfig.propTypes = {
  fields: _propTypes.default.object,
  panel: _propTypes.default.object,
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string])
};