"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNPanelConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _color_rules = require("../color_rules");
var _color_picker = require("../color_picker");
var _yes_no = require("../yes_no");
var _get_default_query_language = require("../lib/get_default_query_language");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _types = require("./types");
var _panel_config = require("./_panel_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/panel_config/top_n.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-ignore should be typed after https://github.com/elastic/kibana/pull/92812 to reduce conflicts
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TopNPanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleTextChange", name => e => this.props.onChange({
      [name]: e.target.value
    }));
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    if (!model.bar_color_rules || !model.bar_color_rules.length) {
      this.props.onChange({
        bar_color_rules: [{
          id: (0, _uuid.v4)()
        }]
      });
    }
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    var _model$drilldown_url, _model$filter, _model$filter2;
    const {
      selectedTab
    } = this.state;
    const defaults = {
      drilldown_url: '',
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      }
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const htmlId = (0, _eui.htmlIdGenerator)();
    const view = selectedTab === _types.PANEL_CONFIG_TABS.DATA ? /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
      colorPicker: false,
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container",
      css: _panel_config.panelConfigContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.optionsTab.dataLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('itemUrl'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.topN.optionsTab.itemUrlLabel",
        defaultMessage: "Item url",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 17
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.topN.optionsTab.itemUrlDescription",
        defaultMessage: "This supports mustache templating. {key} is set to the term.",
        values: {
          key: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 108,
              columnNumber: 36
            }
          }, '{{key}}')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 19
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      onChange: this.handleTextChange('drilldown_url'),
      value: (_model$drilldown_url = model.drilldown_url) !== null && _model$drilldown_url !== void 0 ? _model$drilldown_url : '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      allowIndexSwitchingMode: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('panelFilter'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.topN.optionsTab.panelFilterLabel",
        defaultMessage: "Panel filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 21
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
      },
      onChange: filter => {
        this.props.onChange({
          filter
        });
      },
      indexPatterns: [model.index_pattern],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.topN.optionsTab.ignoreGlobalFilterLabel', {
        defaultMessage: 'Ignore global filter?'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.ignore_global_filter,
      name: "ignore_global_filter",
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.optionsTab.styleLabel",
      defaultMessage: "Style",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.optionsTab.backgroundColorLabel",
      defaultMessage: "Background color:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
      onChange: this.props.onChange,
      name: "background_color",
      value: model.background_color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.optionsTab.colorRulesLabel",
      defaultMessage: "Color rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_color_rules.ColorRules, {
      model: model,
      primaryVarName: "bar_color",
      primaryName: "bar",
      hideSecondary: true,
      onChange: this.props.onChange,
      name: "bar_color_rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    })));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "topNEditorDataBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.dataTab.dataButtonLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "topNEditorPanelOptionsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.topN.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 13
      }
    }))), view);
  }
}
exports.TopNPanelConfig = TopNPanelConfig;