"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newAnnotation = exports.AnnotationsEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _annotation_row = require("./annotation_row");
var _collection_actions = require("./lib/collection_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/annotations_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useContainerStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return (0, _react2.css)({
      padding: euiTheme.size.base,
      backgroundColor: euiTheme.colors.lightestShade
    });
  }, [euiTheme]);
  return styles;
};
const newAnnotation = defaultIndexPattern => () => ({
  id: (0, _uuid.v4)(),
  color: '#F00',
  index_pattern: defaultIndexPattern && defaultIndexPattern.id ? {
    id: defaultIndexPattern.id
  } : '',
  time_field: '',
  icon: 'fa-tag',
  ignore_global_filters: 1,
  ignore_panel_filters: 1
});
exports.newAnnotation = newAnnotation;
const NoContent = ({
  handleAdd
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.annotationsEditor.howToCreateAnnotationDataSourceDescription",
  defaultMessage: "Click the button below to create an annotation data source.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  fill: true,
  onClick: handleAdd,
  "data-test-subj": "addDataSourceButton",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visTypeTimeseries.annotationsEditor.addDataSourceButtonLabel",
  defaultMessage: "Add data source",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 7
  }
})));
const getCollectionActionsProps = props => ({
  name: 'annotations',
  ...props
});
const AnnotationsEditor = props => {
  const {
    annotations
  } = props.model;
  const containerStyles = useContainerStyles();
  const handleAdd = (0, _react.useCallback)(() => _collection_actions.collectionActions.handleAdd(getCollectionActionsProps(props), newAnnotation(props.defaultIndexPattern)), [props]);
  const handleDelete = (0, _react.useCallback)(annotation => () => _collection_actions.collectionActions.handleDelete(getCollectionActionsProps(props), annotation), [props]);
  const onChange = (0, _react.useCallback)(annotation => {
    return part => _collection_actions.collectionActions.handleChange(getCollectionActionsProps(props), {
      ...annotation,
      ...part
    });
  }, [props]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbAnnotationsEditor__container",
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, annotations !== null && annotations !== void 0 && annotations.length ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.annotationsEditor.dataSourcesLabel",
    defaultMessage: "Data sources",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), annotations.map(annotation => /*#__PURE__*/_react.default.createElement(_annotation_row.AnnotationRow, {
    key: annotation.id,
    annotation: annotation,
    fields: props.fields,
    onChange: onChange(annotation),
    handleAdd: handleAdd,
    handleDelete: handleDelete(annotation),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(NoContent, {
    handleAdd: handleAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }));
};
exports.AnnotationsEditor = AnnotationsEditor;