"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileRankAgg = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _agg_select = require("../agg_select");
var _field_select = require("../field_select");
var _create_change_handler = require("../../lib/create_change_handler");
var _create_select_handler = require("../../lib/create_select_handler");
var _create_number_handler = require("../../lib/create_number_handler");
var _agg_row = require("../agg_row");
var _percentile_rank_values = require("./percentile_rank_values");
var _constants = require("../../../../../common/constants");
var _percentile_hdr = require("../percentile_hdr");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/percentile_rank/percentile_rank.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-ignore
const RESTRICT_FIELDS = [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.HISTOGRAM];
const PercentileRankAgg = props => {
  var _model$field;
  const {
    panel,
    fields,
    indexPattern
  } = props;
  const defaults = {
    values: [''],
    colors: [_constants.TSVB_DEFAULT_COLOR]
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const htmlId = (0, _eui.htmlIdGenerator)();
  const isTablePanel = panel.type === 'table';
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(handleChange);
  const percentileRankSeries = panel.series.find(s => s.id === props.series.id) || panel.series[0];
  // If the series is grouped by, then these colors are not respected, no need to display the color picker */
  const isGroupedBy = panel.series.length > 0 && percentileRankSeries.split_mode !== 'everything';
  const enableColorPicker = !isGroupedBy && !['table', 'metric', 'markdown'].includes(panel.type);
  const handlePercentileRankValuesChange = (values, colors) => {
    handleChange({
      ...model,
      values,
      colors
    });
  };
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "s",
    columns: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.percentileRank.aggregationLabel",
    defaultMessage: "Aggregation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.percentileRank.fieldLabel",
      defaultMessage: "Field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }),
    fields: fields,
    type: model.type,
    restrict: RESTRICT_FIELDS,
    indexPattern: indexPattern,
    value: (_model$field = model.field) !== null && _model$field !== void 0 ? _model$field : '',
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.percentileRank.values",
      defaultMessage: "Values",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_percentile_rank_values.PercentileRankValues, {
    disableAdd: isTablePanel,
    disableDelete: isTablePanel,
    showOnlyLastRow: isTablePanel,
    values: model.values,
    colors: model.colors,
    onChange: handlePercentileRankValuesChange,
    enableColorPicker: enableColorPicker,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_percentile_hdr.PercentileHdr, {
    value: model.numberOfSignificantValueDigits,
    onChange: handleNumberChange('numberOfSignificantValueDigits'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
};
exports.PercentileRankAgg = PercentileRankAgg;