"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MovingAverageAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _agg_row = require("./agg_row");
var _agg_select = require("./agg_select");
var _metric_select = require("./metric_select");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _create_number_handler = require("../lib/create_number_handler");
var _enums = require("../../../../common/enums");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/moving_average.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULTS = {
  model_type: _enums.MODEL_TYPES.UNWEIGHTED,
  alpha: 0.3,
  beta: 0.1,
  gamma: 0.3,
  period: 1,
  multiplicative: true,
  window: 5
};
const shouldShowHint = ({
  model_type: type,
  window,
  period
}) => type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_TRIPLE && period * 2 > window;
const MovingAverageAgg = props => {
  const {
    siblings,
    fields,
    indexPattern
  } = props;
  const [model, setModel] = (0, _react.useState)({
    ...DEFAULTS,
    ...props.model
  });
  const onModelChange = (0, _react.useCallback)(newModel => {
    props.onChange(newModel);
    setModel(newModel);
  }, [props]);
  const modelOptions = [{
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelOptions.simpleLabel', {
      defaultMessage: 'Simple'
    }),
    value: _enums.MODEL_TYPES.UNWEIGHTED
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelOptions.linearLabel', {
      defaultMessage: 'Linear'
    }),
    value: _enums.MODEL_TYPES.WEIGHTED_LINEAR
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelOptions.exponentiallyWeightedLabel', {
      defaultMessage: 'Exponentially Weighted'
    }),
    value: _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelOptions.holtLinearLabel', {
      defaultMessage: 'Holt-Linear'
    }),
    value: _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_DOUBLE
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelOptions.holtWintersLabel', {
      defaultMessage: 'Holt-Winters'
    }),
    value: _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_TRIPLE
  }];
  const handleChange = (0, _create_change_handler.createChangeHandler)(onModelChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(handleChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  const selectedModelOption = modelOptions.find(({
    value
  }) => model.model_type === value);
  const multiplicativeOptions = [{
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.multiplicativeOptions.true', {
      defaultMessage: 'True'
    }),
    value: true
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.multiplicativeOptions.false', {
      defaultMessage: 'False'
    }),
    value: false
  }];
  const selectedMultiplicative = multiplicativeOptions.find(({
    value
  }) => model.multiplicative === value);
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('visTypeTimeseries.movingAverage.aggregationLabel', {
    defaultMessage: 'Aggregation'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('metric'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.metricLabel', {
      defaultMessage: 'Metric'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    onChange: handleSelectChange('field'),
    metrics: siblings,
    metric: model,
    fields: fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)],
    value: model.field,
    exclude: [_enums.TSVB_METRIC_TYPES.TOP_HIT],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('model_type'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.modelLabel', {
      defaultMessage: 'Model'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    placeholder: _i18n.i18n.translate('visTypeTimeseries.movingAverage.model.selectPlaceholder', {
      defaultMessage: 'Select'
    }),
    options: modelOptions,
    selectedOptions: selectedModelOption ? [selectedModelOption] : [],
    onChange: handleSelectChange('model_type'),
    singleSelection: {
      asPlainText: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('windowSize'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.windowSizeLabel', {
      defaultMessage: 'Window Size'
    }),
    helpText: shouldShowHint(model) && _i18n.i18n.translate('visTypeTimeseries.movingAverage.windowSizeHint', {
      defaultMessage: 'Window must always be at least twice the size of your period'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    onChange: handleNumberChange('window', {
      isClearable: true
    }),
    value: model.window,
    min: 1,
    isInvalid: !model.window,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  })))), (model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL || model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_DOUBLE || model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_TRIPLE) && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('alpha'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.alpha', {
      defaultMessage: 'Alpha'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    step: 0.1,
    onChange: handleNumberChange('alpha'),
    value: model.alpha,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 19
    }
  }))), (model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_DOUBLE || model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_TRIPLE) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('beta'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.beta', {
      defaultMessage: 'Beta'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    step: 0.1,
    onChange: handleNumberChange('beta'),
    value: model.beta,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 19
    }
  }))), model.model_type === _enums.MODEL_TYPES.WEIGHTED_EXPONENTIAL_TRIPLE && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('gamma'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.gamma', {
      defaultMessage: 'Gamma'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    step: 0.1,
    onChange: handleNumberChange('gamma'),
    value: model.gamma,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('period'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.period', {
      defaultMessage: 'Period'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    step: 1,
    onChange: handleNumberChange('period'),
    value: model.period,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('multiplicative'),
    label: _i18n.i18n.translate('visTypeTimeseries.movingAverage.multiplicative', {
      defaultMessage: 'Multiplicative'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('visTypeTimeseries.movingAverage.multiplicative.selectPlaceholder', {
      defaultMessage: 'Select'
    }),
    options: multiplicativeOptions,
    selectedOptions: selectedMultiplicative ? [selectedMultiplicative] : [],
    onChange: handleSelectChange('multiplicative'),
    singleSelection: {
      asPlainText: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 21
    }
  })))))));
};
exports.MovingAverageAgg = MovingAverageAgg;
MovingAverageAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};