"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CumulativeSumAgg = CumulativeSumAgg;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_row = require("./agg_row");
var _agg_select = require("./agg_select");
var _metric_select = require("./metric_select");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _enums = require("../../../../common/enums");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/cumulative_sum.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function CumulativeSumAgg(props) {
  const {
    model,
    siblings,
    fields,
    indexPattern
  } = props;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.cumulativeSum.aggregationLabel",
    defaultMessage: "Aggregation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('metric'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.cumulativeSum.metricLabel",
      defaultMessage: "Metric",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
    onChange: handleSelectChange('field'),
    metrics: siblings,
    metric: model,
    fields: fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)],
    value: model.field,
    exclude: [_enums.TSVB_METRIC_TYPES.TOP_HIT],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })))));
}
CumulativeSumAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};