"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggSelect = AggSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _check_ui_restrictions = require("../../../../common/check_ui_restrictions");
var _vis_data_context = require("../../contexts/vis_data_context");
var _agg_utils = require("../../../../common/agg_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/agg_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapAggToSelectOption = ({
  id,
  meta
}) => ({
  value: id,
  label: meta.label
});
const {
  metric: metricAggs,
  parent_pipeline: pipelineAggs,
  sibling_pipeline: siblingAggs,
  special: specialAggs
} = (0, _agg_utils.getAggsByType)(mapAggToSelectOption);
const allAggOptions = [...metricAggs, ...pipelineAggs, ...siblingAggs, ...specialAggs];
function AggSelect(props) {
  var _useContext;
  const {
    siblings,
    panelType,
    value,
    onChange,
    ...rest
  } = props;
  const {
    uiRestrictions
  } = (_useContext = (0, _react.useContext)(_vis_data_context.VisDataContext)) !== null && _useContext !== void 0 ? _useContext : {};
  const selectedOptions = allAggOptions.filter(option => {
    return value === option.value && (0, _check_ui_restrictions.isMetricEnabled)(option.value, uiRestrictions);
  });
  let enablePipelines = siblings.some(s => !!metricAggs.find(m => m.value === s.type));
  if (siblings.length <= 1) enablePipelines = false;
  let options;
  if (panelType === 'metrics') {
    options = metricAggs;
  } else if (panelType === 'filter_ratio') {
    options = (0, _agg_utils.getAggsByPredicate)({
      meta: {
        isFilterRatioSupported: true
      }
    }).map(mapAggToSelectOption);
  } else if (panelType === 'histogram') {
    options = (0, _agg_utils.getAggsByPredicate)({
      meta: {
        isHistogramSupported: true
      }
    }).map(mapAggToSelectOption);
  } else {
    const disableSiblingAggs = agg => ({
      ...agg,
      disabled: !enablePipelines || !(0, _check_ui_restrictions.isMetricEnabled)(agg.value, uiRestrictions)
    });
    options = [{
      label: _i18n.i18n.translate('visTypeTimeseries.aggSelect.aggGroups.metricAggLabel', {
        defaultMessage: 'Metric Aggregations'
      }),
      options: metricAggs.map(agg => ({
        ...agg,
        disabled: !(0, _check_ui_restrictions.isMetricEnabled)(agg.value, uiRestrictions)
      }))
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.aggSelect.aggGroups.parentPipelineAggLabel', {
        defaultMessage: 'Parent Pipeline Aggregations'
      }),
      options: pipelineAggs.map(disableSiblingAggs)
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.aggSelect.aggGroups.siblingPipelineAggLabel', {
        defaultMessage: 'Sibling Pipeline Aggregations'
      }),
      options: siblingAggs.map(disableSiblingAggs)
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.aggSelect.aggGroups.specialAggLabel', {
        defaultMessage: 'Special Aggregations'
      }),
      options: specialAggs.map(disableSiblingAggs)
    }];
  }
  const handleChange = currentlySelectedOptions => {
    if (!currentlySelectedOptions || currentlySelectedOptions.length <= 0) return;
    onChange(currentlySelectedOptions);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "aggSelector",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isClearable: false,
    placeholder: _i18n.i18n.translate('visTypeTimeseries.aggSelect.selectAggPlaceholder', {
      defaultMessage: 'Select aggregation'
    }),
    options: options,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    singleSelection: {
      asPlainText: true
    }
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  })));
}