"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const toExpressionAst = vis => {
  const {
    expression,
    interval
  } = vis.params;
  const timelion = (0, _public.buildExpressionFunction)('timelion_vis', {
    expression,
    interval
  });
  const ast = (0, _public.buildExpression)([timelion]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;