"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionVisDefinition = getTimelionVisDefinition;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _constants = require("../common/constants");
var _to_ast = require("./to_ast");
var _plugin_services = require("./helpers/plugin_services");
var _parser_async = require("../common/parser_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/timelion/public/timelion_vis_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelionOptions = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./timelion_options'))));
function getTimelionVisDefinition(dependencies) {
  // return the visType object, which kibana will use to display and configure new
  // Vis object of this type.
  return {
    name: _constants.TIMELION_VIS_NAME,
    title: 'Timelion',
    icon: 'visTimelion',
    description: _i18n.i18n.translate('timelion.timelionDescription', {
      defaultMessage: 'Show time series data on a graph.'
    }),
    visConfig: {
      defaults: {
        expression: '.es(*)',
        interval: 'auto'
      }
    },
    editorConfig: {
      optionsTemplate: props => /*#__PURE__*/_react.default.createElement(TimelionOptions, (0, _extends2.default)({
        services: dependencies
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 9
        }
      })),
      defaultSize: _public.DefaultEditorSize.MEDIUM
    },
    toExpressionAst: _to_ast.toExpressionAst,
    inspectorAdapters: {},
    getSupportedTriggers: () => {
      return [_public2.VIS_EVENT_TO_TRIGGER.applyFilter];
    },
    getUsedIndexPattern: async params => {
      try {
        var _await$parseTimelionE, _await$parseTimelionE2;
        const args = (_await$parseTimelionE = (_await$parseTimelionE2 = await (0, _parser_async.parseTimelionExpressionAsync)(params.expression)) === null || _await$parseTimelionE2 === void 0 ? void 0 : _await$parseTimelionE2.args) !== null && _await$parseTimelionE !== void 0 ? _await$parseTimelionE : [];
        const indexArg = args.find(({
          type,
          name,
          function: fn
        }) => type === 'namedArg' && fn === 'es' && name === 'index');
        if (indexArg !== null && indexArg !== void 0 && indexArg.value.text) {
          return (0, _plugin_services.getIndexPatterns)().find(indexArg.value.text, 1);
        }
      } catch {
        // timelion expression is invalid
      }
      return [];
    },
    options: {
      showIndexSelection: false,
      showFilterBar: false,
      showQueryInput: false
    },
    requiresSearch: true
  };
}