"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.xaxisFormatterProvider = xaxisFormatterProvider;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function xaxisFormatterProvider(config) {
  function getFormat(esInterval) {
    const parts = esInterval.match(/(\d+)(ms|s|m|h|d|w|M|y|)/);
    if (parts === null || parts[1] === null || parts[2] === null) {
      throw new Error(_i18n.i18n.translate('timelion.panels.timechart.unknownIntervalErrorMessage', {
        defaultMessage: 'Unknown interval'
      }));
    }
    const interval = _moment.default.duration(Number(parts[1]), parts[2]);

    // Cribbed from Kibana's TimeBuckets class
    const rules = config.get('dateFormat:scaled');
    for (let i = rules.length - 1; i >= 0; i--) {
      const rule = rules[i];
      if (!rule[0] || interval >= _moment.default.duration(rule[0])) {
        return rule[1];
      }
    }
    return config.get('dateFormat');
  }
  return esInterval => getFormat(esInterval);
}