"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _common = require("@kbn/expression-partition-vis-plugin/common");
var _truncate_labels = require("./truncate_labels");
var _common2 = require("../../../common");
var _collections = require("../collections");
var _positions = require("../positions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/pie/public/editor/components/pie.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptySizeRatioLabel = _i18n.i18n.translate('visTypePie.editors.pie.emptySizeRatioLabel', {
  defaultMessage: 'Inner area size'
});
function DecimalSlider({
  paramName,
  value,
  setValue
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('visTypePie.editors.pie.decimalSliderLabel', {
      defaultMessage: 'Maximum decimal places for percent'
    }),
    "data-test-subj": "visTypePieValueDecimals",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    value: value,
    min: 0,
    max: 4,
    showInput: true,
    compressed: true,
    onChange: e => {
      setValue(paramName, Number(e.currentTarget.value));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
}
const PieOptions = props => {
  var _props$uiState, _aggs$aggs, _aggs$aggs$filter, _aggs$aggs2, _emptySizeRatioOption2, _emptySizeRatioOption3, _stateParams$truncate, _stateParams$maxLegen, _stateParams$labels$p;
  const {
    stateParams,
    setValue,
    aggs
  } = props;
  const setLabels = (paramName, value) => setValue('labels', {
    ...stateParams.labels,
    [paramName]: value
  });
  const legendUiStateValue = (_props$uiState = props.uiState) === null || _props$uiState === void 0 ? void 0 : _props$uiState.get('vis.legendOpen');
  const [palettesRegistry, setPalettesRegistry] = (0, _react.useState)(undefined);
  const [legendVisibility, setLegendVisibility] = (0, _react.useState)(() => {
    var _props$uiState2;
    const bwcLegendStateDefault = stateParams.legendDisplay === _common.LegendDisplay.SHOW;
    return (_props$uiState2 = props.uiState) === null || _props$uiState2 === void 0 ? void 0 : _props$uiState2.get('vis.legendOpen', bwcLegendStateDefault);
  });
  const hasSplitChart = Boolean(aggs === null || aggs === void 0 ? void 0 : (_aggs$aggs = aggs.aggs) === null || _aggs$aggs === void 0 ? void 0 : _aggs$aggs.find(agg => agg.schema === 'split' && agg.enabled));
  const segments = (_aggs$aggs$filter = aggs === null || aggs === void 0 ? void 0 : (_aggs$aggs2 = aggs.aggs) === null || _aggs$aggs2 === void 0 ? void 0 : _aggs$aggs2.filter(agg => agg.schema === 'segment' && agg.enabled)) !== null && _aggs$aggs$filter !== void 0 ? _aggs$aggs$filter : [];
  const legendSize = stateParams.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public2.LegendSize.AUTO);
  const getLegendDisplay = (0, _react.useCallback)(isVisible => isVisible ? _common.LegendDisplay.SHOW : _common.LegendDisplay.HIDE, []);
  (0, _react.useEffect)(() => {
    setLegendVisibility(legendUiStateValue !== null && legendUiStateValue !== void 0 ? legendUiStateValue : stateParams.legendDisplay === _common.LegendDisplay.SHOW);
  }, [legendUiStateValue, stateParams.legendDisplay]);
  (0, _react.useEffect)(() => {
    const fetchPalettes = async () => {
      var _props$palettes;
      const palettes = await ((_props$palettes = props.palettes) === null || _props$palettes === void 0 ? void 0 : _props$palettes.getPalettes());
      setPalettesRegistry(palettes);
    };
    fetchPalettes();
  }, [props.palettes]);
  const handleEmptySizeRatioChange = (0, _react.useCallback)(sizeId => {
    var _emptySizeRatioOption;
    const emptySizeRatio = (_emptySizeRatioOption = _collections.emptySizeRatioOptions.find(({
      id
    }) => id === sizeId)) === null || _emptySizeRatioOption === void 0 ? void 0 : _emptySizeRatioOption.value;
    setValue('emptySizeRatio', emptySizeRatio);
  }, [setValue]);
  const handleLegendSizeChange = (0, _react.useCallback)(size => setValue('legendSize', size), [setValue]);
  const handleLegendDisplayChange = (0, _react.useCallback)((name, show) => {
    var _props$uiState3;
    setLegendVisibility(show);
    const legendDisplay = getLegendDisplay(show);
    if (legendDisplay === stateParams[name]) {
      setValue(name, getLegendDisplay(!show));
    }
    setValue(name, legendDisplay);
    (_props$uiState3 = props.uiState) === null || _props$uiState3 === void 0 ? void 0 : _props$uiState3.set('vis.legendOpen', show);
  }, [getLegendDisplay, props.uiState, setValue, stateParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypePie.editors.pie.pieSettingsTitle",
    defaultMessage: "Pie settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.donutLabel', {
      defaultMessage: 'Donut'
    }),
    paramName: "isDonut",
    value: stateParams.isDonut,
    setValue: setValue,
    "data-test-subj": "visTypePieIsDonut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }), props.showElasticChartsOptions && stateParams.isDonut && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: emptySizeRatioLabel,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    name: "emptySizeRatio",
    buttonSize: "compressed",
    legend: emptySizeRatioLabel,
    options: _collections.emptySizeRatioOptions,
    idSelected: (_emptySizeRatioOption2 = (_emptySizeRatioOption3 = _collections.emptySizeRatioOptions.find(({
      value
    }) => value === stateParams.emptySizeRatio)) === null || _emptySizeRatioOption3 === void 0 ? void 0 : _emptySizeRatioOption3.id) !== null && _emptySizeRatioOption2 !== void 0 ? _emptySizeRatioOption2 : 'emptySizeRatioOption-small',
    onChange: handleEmptySizeRatioChange,
    "data-test-subj": "visTypePieEmptySizeRatioButtonGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_public.BasicOptions, (0, _extends2.default)({}, props, {
    legendPositions: _positions.getLegendPositions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  })), props.showElasticChartsOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.distinctColorsLabel', {
      defaultMessage: 'Use distinct colors per slice'
    }),
    paramName: "distinctColors",
    value: stateParams.distinctColors,
    disabled: (segments === null || segments === void 0 ? void 0 : segments.length) <= 1 && !hasSplitChart,
    setValue: setValue,
    "data-test-subj": "visTypePiedistinctColorsSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: "Use with multi-layer chart or multiple charts.",
    position: "top",
    type: "info",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.legendDisplayLabel', {
      defaultMessage: 'Show legend'
    }),
    paramName: "legendDisplay",
    value: legendVisibility,
    setValue: handleLegendDisplayChange,
    "data-test-subj": "visTypePieAddLegendSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.nestedLegendLabel', {
      defaultMessage: 'Nest legend'
    }),
    paramName: "nestedLegend",
    value: stateParams.nestedLegend,
    disabled: stateParams.legendDisplay === _common.LegendDisplay.HIDE,
    setValue: (paramName, value) => {
      setValue(paramName, value);
    },
    "data-test-subj": "visTypePieNestedLegendSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_public.LongLegendOptions, {
    "data-test-subj": "pieLongLegendsOptions",
    truncateLegend: (_stateParams$truncate = stateParams.truncateLegend) !== null && _stateParams$truncate !== void 0 ? _stateParams$truncate : true,
    maxLegendLines: (_stateParams$maxLegen = stateParams.maxLegendLines) !== null && _stateParams$maxLegen !== void 0 ? _stateParams$maxLegen : 1,
    setValue: setValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_public.LegendSizeSettings, {
    legendSize: legendSize,
    onLegendSizeChange: handleLegendSizeChange,
    isVerticalLegend: stateParams.legendPosition === _charts.Position.Left || stateParams.legendPosition === _charts.Position.Right,
    showAutoOption: hadAutoLegendSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  })), props.showElasticChartsOptions && palettesRegistry && /*#__PURE__*/_react.default.createElement(_public.PalettePicker, {
    palettes: palettesRegistry,
    activePalette: stateParams.palette,
    paramName: "palette",
    setPalette: (paramName, value) => {
      setValue(paramName, value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypePie.editors.pie.labelsSettingsTitle",
    defaultMessage: "Labels settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.showLabelsLabel', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: stateParams.labels.show,
    setValue: setLabels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }), props.showElasticChartsOptions && /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.labelPositionLabel', {
      defaultMessage: 'Label position'
    }),
    disabled: !stateParams.labels.show || hasSplitChart,
    options: _collections.getLabelPositions,
    paramName: "position",
    value: hasSplitChart ? _common.LabelPositions.INSIDE : stateParams.labels.position || _common.LabelPositions.DEFAULT,
    setValue: (paramName, value) => {
      setLabels(paramName, value);
    },
    "data-test-subj": "visTypePieLabelPositionSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.showTopLevelOnlyLabel', {
      defaultMessage: 'Show top level only'
    }),
    disabled: !stateParams.labels.show || props.showElasticChartsOptions && stateParams.labels.position === _common.LabelPositions.INSIDE,
    paramName: "last_level",
    value: stateParams.labels.last_level,
    setValue: setLabels,
    "data-test-subj": "visTypePieTopLevelSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.showValuesLabel', {
      defaultMessage: 'Show values'
    }),
    disabled: !stateParams.labels.show,
    paramName: "values",
    value: stateParams.labels.values,
    setValue: setLabels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }), props.showElasticChartsOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypePie.editors.pie.valueFormatsLabel', {
      defaultMessage: 'Values'
    }),
    disabled: !stateParams.labels.values,
    options: _collections.getValuesFormats,
    paramName: "valuesFormat",
    value: stateParams.labels.valuesFormat || _common.ValueFormats.PERCENT,
    setValue: (paramName, value) => {
      setLabels(paramName, value);
    },
    "data-test-subj": "visTypePieValueFormatsSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(DecimalSlider, {
    paramName: "percentDecimals",
    value: (_stateParams$labels$p = stateParams.labels.percentDecimals) !== null && _stateParams$labels$p !== void 0 ? _stateParams$labels$p : _common2.DEFAULT_PERCENT_DECIMALS,
    setValue: setLabels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_truncate_labels.TruncateLabelsOption, {
    value: stateParams.labels.truncate,
    setValue: setLabels,
    disabled: props.showElasticChartsOptions && stateParams.labels.position === _common.LabelPositions.INSIDE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 9
    }
  })));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = PieOptions;
module.exports = exports.default;