"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVisOptions = MetricVisOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/metric/public/components/metric_vis_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const metricColorMode = [{
  id: _public2.ColorMode.None,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.noneOptionLabel', {
    defaultMessage: 'None'
  })
}, {
  id: _public2.ColorMode.Labels,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.labelsOptionLabel', {
    defaultMessage: 'Labels'
  })
}, {
  id: _public2.ColorMode.Background,
  label: _i18n.i18n.translate('visTypeMetric.colorModes.backgroundOptionLabel', {
    defaultMessage: 'Background'
  })
}];
function MetricVisOptions({
  stateParams,
  setValue,
  setValidity,
  setTouched,
  uiState
}) {
  const setMetricValue = (0, _react.useCallback)((paramName, value) => setValue('metric', {
    ...stateParams.metric,
    [paramName]: value
  }), [setValue, stateParams.metric]);
  const setMetricLabels = (0, _react.useCallback)((paramName, value) => setMetricValue('labels', {
    ...stateParams.metric.labels,
    [paramName]: value
  }), [setMetricValue, stateParams.metric.labels]);
  const setMetricStyle = (0, _react.useCallback)((paramName, value) => setMetricValue('style', {
    ...stateParams.metric.style,
    [paramName]: value
  }), [setMetricValue, stateParams.metric.style]);
  const setColorMode = (0, _react.useCallback)(id => setMetricValue('metricColorMode', id), [setMetricValue]);
  const metricColorModeLabel = _i18n.i18n.translate('visTypeMetric.params.color.useForLabel', {
    defaultMessage: 'Use color for'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.settingsTitle",
    defaultMessage: "Settings",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.PercentageModeOption, {
    "data-test-subj": "metricPercentageMode",
    percentageMode: stateParams.metric.percentageMode,
    formatPattern: stateParams.metric.percentageFormatPattern,
    setValue: setMetricValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeMetric.params.showTitleLabel', {
      defaultMessage: 'Show title'
    }),
    paramName: "show",
    value: stateParams.metric.labels.show,
    setValue: setMetricLabels,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.rangesTitle",
    defaultMessage: "Ranges",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ColorRanges, {
    "data-test-subj": "metricColorRange",
    colorsRange: stateParams.metric.colorsRange,
    setValue: setMetricValue,
    setTouched: setTouched,
    setValidity: setValidity,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "rowCompressed",
    label: metricColorModeLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    idSelected: stateParams.metric.metricColorMode,
    isDisabled: stateParams.metric.colorsRange.length === 1,
    isFullWidth: true,
    legend: metricColorModeLabel,
    options: metricColorMode,
    onChange: setColorMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_public.ColorSchemaOptions, {
    colorSchema: stateParams.metric.colorSchema,
    colorSchemas: _public2.colorSchemas,
    disabled: stateParams.metric.colorsRange.length === 1 || stateParams.metric.metricColorMode === _public2.ColorMode.None,
    invertColors: stateParams.metric.invertColors,
    setValue: setMetricValue,
    showHelpText: false,
    uiState: uiState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeMetric.params.style.styleTitle",
    defaultMessage: "Style",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_public.RangeOption, {
    label: _i18n.i18n.translate('visTypeMetric.params.style.fontSizeLabel', {
      defaultMessage: 'Metric font size in points'
    }),
    min: 12,
    max: 120,
    paramName: "fontSize",
    value: stateParams.metric.style.fontSize,
    setValue: setMetricStyle,
    showInput: true,
    showLabels: true,
    showValue: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })));
}