"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markdownVisType = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _markdown_options = require("./markdown_options");
var _settings_options_lazy = require("./settings_options_lazy");
var _to_ast = require("./to_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const markdownVisType = exports.markdownVisType = {
  name: 'markdown',
  title: 'Markdown',
  isAccessible: true,
  icon: 'visText',
  group: _public2.VisGroups.TOOLS,
  disableEdit: true,
  titleInWizard: _i18n.i18n.translate('visTypeMarkdown.markdownTitleInWizard', {
    defaultMessage: 'Markdown text'
  }),
  description: _i18n.i18n.translate('visTypeMarkdown.markdownDescription', {
    defaultMessage: 'Add custom text or images to dashboards.'
  }),
  order: 30,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      fontSize: 12,
      openLinksInNewTab: false,
      markdown: ''
    }
  },
  editorConfig: {
    optionTabs: [{
      name: 'advanced',
      title: _i18n.i18n.translate('visTypeMarkdown.tabs.dataText', {
        defaultMessage: 'Data'
      }),
      editor: _markdown_options.MarkdownOptions
    }, {
      name: 'options',
      title: _i18n.i18n.translate('visTypeMarkdown.tabs.optionsText', {
        defaultMessage: 'Options'
      }),
      editor: _settings_options_lazy.SettingsOptions
    }],
    enableAutoApply: true,
    defaultSize: _public.DefaultEditorSize.LARGE
  },
  options: {
    showTimePicker: false,
    showFilterBar: false,
    showQueryInput: false
  },
  inspectorAdapters: {}
};