"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGaugeVisTypeDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/charts-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _types = require("../types");
var _to_ast = require("../to_ast");
var _components = require("../editor/components");
var _split_tooltip = require("./split_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/gauge/public/vis_type/gauge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getGaugeVisTypeDefinition = props => ({
  name: 'gauge',
  title: _i18n.i18n.translate('visTypeGauge.gauge.gaugeTitle', {
    defaultMessage: 'Gauge'
  }),
  icon: 'visGauge',
  description: _i18n.i18n.translate('visTypeGauge.gauge.gaugeDescription', {
    defaultMessage: 'Show the status of a metric.'
  }),
  getSupportedTriggers: () => [_public3.VIS_EVENT_TO_TRIGGER.filter],
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      type: 'gauge',
      addTooltip: true,
      addLegend: true,
      isDisplayWarning: false,
      gauge: {
        alignment: _types.Alignment.Automatic,
        extendRange: true,
        percentageMode: false,
        gaugeType: _types.GaugeType.Arc,
        gaugeStyle: 'Full',
        backStyle: 'Full',
        orientation: 'vertical',
        colorSchema: _public.ColorSchemas.GreenToRed,
        gaugeColorMode: _public.ColorMode.Labels,
        colorsRange: [{
          from: 0,
          to: 50
        }, {
          from: 50,
          to: 75
        }, {
          from: 75,
          to: 100
        }],
        invertColors: false,
        labels: {
          show: true,
          color: 'black'
        },
        scale: {
          show: true,
          labels: false,
          color: 'rgba(105,112,125,0.2)'
        },
        type: 'meter',
        style: {
          bgWidth: 0.9,
          width: 0.9,
          mask: false,
          bgMask: false,
          maskBars: 50,
          bgFill: 'rgba(105,112,125,0.2)',
          bgColor: true,
          subText: '',
          fontSize: 60
        }
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: (0, _components.getGaugeOptions)(props),
    schemas: [{
      group: _public2.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeGauge.gauge.metricTitle', {
        defaultMessage: 'Metric'
      }),
      min: 1,
      ...(props.showElasticChartsOptions ? {
        max: 1
      } : {}),
      aggFilter: ['!std_dev', '!geo_centroid', '!percentiles', '!percentile_ranks', '!derivative', '!serial_diff', '!moving_avg', '!cumulative_sum', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public2.AggGroupNames.Buckets,
      name: 'group',
      // TODO: Remove when split chart aggs are supported
      ...(props.showElasticChartsOptions && {
        disabled: true,
        tooltip: /*#__PURE__*/_react.default.createElement(_split_tooltip.SplitTooltip, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 20
          }
        })
      }),
      title: _i18n.i18n.translate('visTypeGauge.gauge.groupTitle', {
        defaultMessage: 'Split group'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertGaugeToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return vis ? convertGaugeToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertGaugeToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertGaugeToLens(vis, timeFilter) : null)
    };
  }
});
exports.getGaugeVisTypeDefinition = getGaugeVisTypeDefinition;