"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToLens = void 0;
var _uuid = require("uuid");
var _public = require("@kbn/visualizations-plugin/public");
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _services = require("../services");
var _goal = require("./configurations/goal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const convertToLens = async (vis, timefilter) => {
  var _vis$data$indexPatter;
  if (!timefilter) {
    return null;
  }
  const dataViews = (0, _services.getDataViewsStart)();
  const dataView = await (0, _public.getDataViewByIndexPatternId)((_vis$data$indexPatter = vis.data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.id, dataViews);
  if (!dataView) {
    return null;
  }
  const {
    getColumnsFromVis,
    getPalette,
    getPercentageModeConfig,
    createStaticValueColumn
  } = await (0, _public.getConvertToLensModule)();
  const percentageModeConfig = getPercentageModeConfig(vis.params.gauge, false);
  const layers = getColumnsFromVis(vis, timefilter, dataView, {
    splits: ['group']
  }, {
    dropEmptyRowsInDateHistogram: true,
    ...percentageModeConfig
  });
  if (layers === null) {
    return null;
  }
  const [layerConfig] = layers;

  // for now, multiple metrics are not supported
  if (layerConfig.metrics.length > 1 || layerConfig.buckets.all.length > 1) {
    return null;
  }
  if (layerConfig.metrics[0]) {
    const metric = layerConfig.columns.find(({
      columnId
    }) => columnId === layerConfig.metrics[0]);
    if ((metric === null || metric === void 0 ? void 0 : metric.dataType) !== 'number') {
      return null;
    }
  }
  const {
    isPercentageMode,
    max
  } = percentageModeConfig;
  const maxColumn = createStaticValueColumn(isPercentageMode ? 1 : max);
  const columns = [...layerConfig.columns, maxColumn];
  const layerId = (0, _uuid.v4)();
  const indexPatternId = dataView.id;
  return {
    type: 'lnsMetric',
    layers: [{
      indexPatternId,
      layerId,
      columns: columns.map(_convert_to_lens.excludeMetaFromColumn),
      columnOrder: [],
      ignoreGlobalFilters: false
    }],
    configuration: (0, _goal.getConfiguration)(layerId, vis.params, getPalette(vis.params.gauge, percentageModeConfig, true), {
      ...layerConfig,
      maxAccessor: maxColumn.columnId
    }),
    indexPatternIds: [indexPatternId]
  };
};
exports.convertToLens = convertToLens;