"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeIntervalParamEditor = TimeIntervalParamEditor;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/time_interval.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  parseEsInterval,
  InvalidEsCalendarIntervalError
} = _public.search.aggs;

// we check if Elasticsearch interval is valid to show a user appropriate error message
// e.g. there is the case when a user inputs '14d' but it's '2w' in expression equivalent and the request will fail
// we don't check it for 0ms because the overall time range has not yet been set
function isValidCalendarInterval(interval) {
  if (interval === '0ms') {
    return {
      isValidCalendarValue: true
    };
  }
  try {
    parseEsInterval(interval);
    return {
      isValidCalendarValue: true
    };
  } catch (e) {
    if (e instanceof InvalidEsCalendarIntervalError) {
      return {
        isValidCalendarValue: false,
        error: e.message
      };
    }
    return {
      isValidCalendarValue: true
    };
  }
}
const errorMessage = _i18n.i18n.translate('visDefaultEditor.controls.timeInterval.invalidFormatErrorMessage', {
  defaultMessage: 'Invalid interval format.'
});
const autoInterval = 'auto';
function validateInterval(agg, value, definedOption, timeBase) {
  var _agg$buckets2;
  if (definedOption) {
    var _agg$buckets;
    return {
      isValid: true,
      interval: (_agg$buckets = agg.buckets) === null || _agg$buckets === void 0 ? void 0 : _agg$buckets.getInterval()
    };
  }
  if (!value || value === autoInterval && !definedOption) {
    return {
      isValid: false
    };
  }
  if (!timeBase) {
    // we check if Elasticsearch interval is valid ES interval to show a user appropriate error message
    // we don't check if there is timeBase
    const {
      isValidCalendarValue,
      error
    } = isValidCalendarInterval(value);
    if (!isValidCalendarValue) {
      return {
        isValid: false,
        error
      };
    }
  }
  const isValid = _public.search.aggs.isValidInterval(value, timeBase);
  if (!isValid) {
    return {
      isValid: false,
      error: errorMessage
    };
  }
  const interval = (_agg$buckets2 = agg.buckets) === null || _agg$buckets2 === void 0 ? void 0 : _agg$buckets2.getInterval();
  const {
    isValidCalendarValue,
    error
  } = isValidCalendarInterval(interval.expression);
  if (!isValidCalendarValue) {
    return {
      isValid: false,
      error
    };
  }
  return {
    isValid,
    interval
  };
}
function TimeIntervalParamEditor({
  agg,
  aggParam,
  editorConfig,
  value,
  setValue,
  showValidation,
  setTouched,
  setValidity
}) {
  const timeBase = (0, _lodash.get)(editorConfig, 'interval.timeBase');
  const options = timeBase ? [] : (aggParam.options || []).reduce((filtered, option) => {
    if (option.enabled ? option.enabled(agg) : true) {
      filtered.push({
        label: option.display,
        key: option.val
      });
    }
    return filtered;
  }, []);
  let selectedOptions = [];
  let definedOption;
  if (value) {
    definedOption = (0, _lodash.find)(options, {
      key: value
    });
    selectedOptions = definedOption ? [definedOption] : value === autoInterval ? [] : [{
      label: value,
      key: 'custom'
    }];
  }
  const {
    isValid,
    error,
    interval
  } = validateInterval(agg, value, definedOption, timeBase);
  const scaledHelpText = interval && interval.scaled ? /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": "currentlyScaledText",
    className: "eui-displayBlock",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.timeInterval.scaledHelpText",
    defaultMessage: "Currently scaled to {bucketDescription}",
    values: {
      bucketDescription: (0, _lodash.get)(interval, 'description') || ''
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    type: "question",
    content: interval.scale <= 1 ? tooManyBucketsTooltip : tooLargeBucketsTooltip,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  })) : null;
  const helpText = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, scaledHelpText, (0, _lodash.get)(editorConfig, 'interval.help') || selectOptionHelpText);
  const onCustomInterval = customValue => setValue(customValue.trim());
  const onChange = opts => {
    const selectedOpt = (0, _lodash.get)(opts, '0');
    setValue(selectedOpt ? selectedOpt.key : '');
  };
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    error: error,
    fullWidth: true,
    helpText: helpText,
    isInvalid: showValidation && !isValid,
    label: _i18n.i18n.translate('visDefaultEditor.controls.timeInterval.minimumIntervalLabel', {
      defaultMessage: 'Minimum interval'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    fullWidth: true,
    "data-test-subj": "visEditorInterval",
    isInvalid: showValidation && !isValid,
    noSuggestions: !!timeBase,
    onChange: onChange,
    onCreateOption: onCustomInterval,
    options: options,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    placeholder: _i18n.i18n.translate('visDefaultEditor.controls.timeInterval.selectIntervalPlaceholder', {
      defaultMessage: 'Select an interval'
    }),
    onBlur: setTouched,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }));
}
const tooManyBucketsTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.timeInterval.createsTooManyBucketsTooltip",
  defaultMessage: "This interval creates too many buckets to show in the selected time range, so it has been scaled up.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 195,
    columnNumber: 3
  }
});
const tooLargeBucketsTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.timeInterval.createsTooLargeBucketsTooltip",
  defaultMessage: "This interval creates buckets that are too large to show in the selected time range, so it has been scaled down.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 201,
    columnNumber: 3
  }
});
const selectOptionHelpText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.timeInterval.selectOptionHelpText",
  defaultMessage: "Select an option or create a custom value. Examples: 30s, 20m, 24h, 2d, 1w, 1M",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 207,
    columnNumber: 3
  }
});