"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubMetricParamEditor = SubMetricParamEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _public = require("@kbn/data-plugin/public");
var _utils = require("./utils");
var _agg_params = require("../agg_params");
var _agg = require("../../_agg.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/sub_metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function SubMetricParamEditor({
  agg,
  aggParam,
  formIsTouched,
  metricAggs,
  state,
  setValue,
  setValidity,
  setTouched,
  schemas
}) {
  const metricTitle = _i18n.i18n.translate('visDefaultEditor.controls.metrics.metricTitle', {
    defaultMessage: 'Metric'
  });
  const bucketTitle = _i18n.i18n.translate('visDefaultEditor.controls.metrics.bucketTitle', {
    defaultMessage: 'Bucket'
  });
  const type = aggParam.name;
  const isCustomMetric = type === 'customMetric';
  const aggTitle = isCustomMetric ? metricTitle : bucketTitle;
  const aggGroup = isCustomMetric ? _public.AggGroupNames.Metrics : _public.AggGroupNames.Buckets;
  (0, _useMount.default)(() => {
    if (agg.params[type]) {
      setValue(agg.params[type]);
    } else {
      setValue(aggParam.makeAgg(agg));
    }
  });
  const {
    onAggTypeChange,
    setAggParamValue
  } = (0, _utils.useSubAggParamsHandlers)(agg, aggParam, agg.params[type], setValue);
  if (!agg.params[type]) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, aggTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_params.DefaultEditorAggParams, {
    agg: agg.params[type],
    allowedAggs: aggParam.allowedAggs,
    groupName: aggGroup,
    className: "visEditorAgg__subAgg",
    formIsTouched: formIsTouched,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setValidity: setValidity,
    setTouched: setTouched,
    schemas: schemas,
    hideCustomLabel: !isCustomMetric,
    css: _agg.visEditorSubAggStyles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
}