"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubAggParamEditor = SubAggParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _utils = require("./utils");
var _agg_params = require("../agg_params");
var _agg = require("../../_agg.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/sub_agg.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SubAggParamEditor({
  agg,
  aggParam,
  formIsTouched,
  metricAggs,
  state,
  setValue,
  setValidity,
  setTouched,
  schemas
}) {
  (0, _react.useEffect)(() => {
    // we aren't creating a custom aggConfig
    if (agg.params.metricAgg !== 'custom') {
      setValue(undefined);
    } else if (!agg.params.customMetric) {
      setValue(aggParam.makeAgg(agg));
    }
  }, [metricAggs, agg, setValue, aggParam]);
  const {
    onAggTypeChange,
    setAggParamValue
  } = (0, _utils.useSubAggParamsHandlers)(agg, aggParam, agg.params.customMetric, setValue);
  if (agg.params.metricAgg !== 'custom' || !agg.params.customMetric) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_params.DefaultEditorAggParams, {
    agg: agg.params.customMetric,
    allowedAggs: aggParam.allowedAggs,
    groupName: _public.AggGroupNames.Metrics,
    className: "visEditorAgg__subAgg",
    formIsTouched: formIsTouched,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setValidity: setValidity,
    setTouched: setTouched,
    schemas: schemas,
    hideCustomLabel: true,
    css: _agg.visEditorSubAggStyles,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
}