"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangesParamEditor = RangesParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/ranges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FROM_PLACEHOLDER = '\u2212\u221E';
const TO_PLACEHOLDER = '+\u221E';
const generateId = (0, _eui.htmlIdGenerator)();
const isEmpty = value => value === undefined || value === null;
function RangesParamEditor({
  'data-test-subj': dataTestSubj = 'range',
  addRangeValues,
  error,
  value = [],
  hidePlaceholders,
  setValue,
  setTouched,
  setValidity,
  validateRange
}) {
  const [ranges, setRanges] = (0, _react.useState)(() => value.map(range => ({
    ...range,
    id: generateId()
  })));
  const updateRanges = (0, _react.useCallback)(rangeValues => {
    // do not set internal id parameter into saved object
    setValue(rangeValues.map(range => (0, _lodash.omit)(range, 'id')));
    setRanges(rangeValues);
    if (setTouched) {
      setTouched(true);
    }
  }, [setTouched, setValue]);
  const onAddRange = (0, _react.useCallback)(() => addRangeValues ? updateRanges([...ranges, {
    ...addRangeValues(),
    id: generateId()
  }]) : updateRanges([...ranges, {
    id: generateId()
  }]), [addRangeValues, ranges, updateRanges]);
  const onRemoveRange = id => updateRanges(ranges.filter(range => range.id !== id));
  const onChangeRange = (id, key, newValue) => updateRanges(ranges.map(range => range.id === id ? {
    ...range,
    [key]: newValue === '' ? undefined : parseFloat(newValue)
  } : range));

  // set up an initial range when there is no default range
  (0, _react.useEffect)(() => {
    if (!value.length) {
      onAddRange();
    }
  }, [onAddRange, value.length]);
  (0, _react.useEffect)(() => {
    // responsible for discarding changes
    if (value.length !== ranges.length || value.some((range, index) => !(0, _lodash.isEqual)(range, (0, _lodash.omit)(ranges[index], 'id')))) {
      setRanges(value.map(range => ({
        ...range,
        id: generateId()
      })));
    }
  }, [ranges, value]);
  const hasInvalidRange = validateRange && ranges.some(({
    from,
    to,
    id
  }, index) => {
    const [isFromValid, isToValid] = validateRange({
      from,
      to
    }, index);
    return !isFromValid || !isToValid;
  });
  (0, _react.useEffect)(() => {
    if (setValidity) {
      setValidity(!hasInvalidRange);
    }
  }, [hasInvalidRange, setValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ranges.map(({
    from,
    to,
    id
  }, index) => {
    const deleteBtnTitle = _i18n.i18n.translate('visDefaultEditor.controls.ranges.removeRangeButtonAriaLabel', {
      defaultMessage: 'Remove the range of {from} to {to}',
      values: {
        from: isEmpty(from) ? FROM_PLACEHOLDER : from,
        to: isEmpty(to) ? TO_PLACEHOLDER : to
      }
    });
    let isFromValid = true;
    let isToValid = true;
    if (validateRange) {
      [isFromValid, isToValid] = validateRange({
        from,
        to
      }, index);
    }
    const gtePrependLabel = _i18n.i18n.translate('visDefaultEditor.controls.ranges.greaterThanOrEqualPrepend', {
      defaultMessage: '\u2265'
    });
    const gteTooltipContent = _i18n.i18n.translate('visDefaultEditor.controls.ranges.greaterThanOrEqualTooltip', {
      defaultMessage: 'Greater than or equal to'
    });
    const ltPrependLabel = _i18n.i18n.translate('visDefaultEditor.controls.ranges.lessThanPrepend', {
      defaultMessage: '\u003c'
    });
    const ltTooltipContent = _i18n.i18n.translate('visDefaultEditor.controls.ranges.lessThanTooltip', {
      defaultMessage: 'Less than'
    });
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.ranges.fromLabel', {
        defaultMessage: 'From'
      }),
      "data-test-subj": `${dataTestSubj}${index}__from`,
      value: isEmpty(from) ? '' : from,
      placeholder: hidePlaceholders ? undefined : FROM_PLACEHOLDER,
      onChange: ev => onChangeRange(id, 'from', ev.target.value),
      fullWidth: true,
      compressed: true,
      isInvalid: !isFromValid,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: gteTooltipContent,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 25
        }
      }, gtePrependLabel)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortRight",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.ranges.toLabel', {
        defaultMessage: 'To'
      }),
      "data-test-subj": `${dataTestSubj}${index}__to`,
      value: isEmpty(to) ? '' : to,
      placeholder: hidePlaceholders ? undefined : TO_PLACEHOLDER,
      onChange: ev => onChangeRange(id, 'to', ev.target.value),
      fullWidth: true,
      compressed: true,
      isInvalid: !isToValid,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: ltTooltipContent,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 25
        }
      }, ltPrependLabel)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      title: deleteBtnTitle,
      "aria-label": deleteBtnTitle,
      disabled: value.length === 1,
      color: "danger",
      iconType: "trash",
      onClick: () => onRemoveRange(id),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 15
      }
    }));
  }), hasInvalidRange && error && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 38
    }
  }, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `${dataTestSubj}__addRangeButton`,
    iconType: "plusInCircleFilled",
    onClick: onAddRange,
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.ranges.addRangeButtonLabel",
    defaultMessage: "Add range",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 13
    }
  })))));
}