"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = PalettePicker;
var _react = _interopRequireDefault(require("react"));
var _coloring = require("@kbn/coloring");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palettes = require("@kbn/palettes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DEFAULT_PALETTE = 'default';
function PalettePicker({
  activePalette,
  palettes,
  paramName,
  setPalette
}) {
  const paletteName = (0, _coloring.getActivePaletteName)(activePalette === null || activePalette === void 0 ? void 0 : activePalette.name);
  const palettesList = palettes.getAll().filter(({
    internal
  }) => !internal).map(({
    id,
    title,
    tag,
    getCategoricalColors
  }) => {
    return {
      value: id,
      title,
      type: 'fixed',
      append: (0, _palettes.getAppendedTag)(tag),
      palette: getCategoricalColors(10, id === paletteName ? activePalette === null || activePalette === void 0 ? void 0 : activePalette.params : undefined)
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('visDefaultEditor.palettePicker.label', {
      defaultMessage: 'Color palette'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    fullWidth: true,
    "data-test-subj": "visEditorPalettePicker",
    compressed: true,
    palettes: palettesList,
    onChange: newPalette => {
      var _palette$value;
      const palette = palettesList.find(item => item.value === newPalette);
      setPalette(paramName, {
        type: 'palette',
        name: (_palette$value = palette === null || palette === void 0 ? void 0 : palette.value) !== null && _palette$value !== void 0 ? _palette$value : DEFAULT_PALETTE
      });
    },
    valueOfSelected: paletteName,
    selectionDisplay: 'palette',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
}