"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputList = InputList;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/components/input_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// InputModel can have the following implementations:
// for Mask List - { id: 'someId', mask: { model: '', value: '', isInvalid: false }}
// for FromTo List - { id: 'someId', from: { model: '', value: '', isInvalid: false }, to: { model: '', value: '', isInvalid: false }}

const generateId = (0, _eui.htmlIdGenerator)();
const validateValue = (inputValue, InputObject) => {
  const result = {
    model: inputValue || '',
    isInvalid: false
  };
  if (!inputValue) {
    result.isInvalid = false;
    return result;
  }
  try {
    result.model = new InputObject(inputValue).toString();
    result.isInvalid = false;
    return result;
  } catch (e) {
    result.isInvalid = true;
    return result;
  }
};
function InputList({
  config,
  list,
  onChange,
  setValidity
}) {
  const {
    defaultValue,
    getModelValue,
    modelNames,
    onChangeFn,
    validateClass
  } = config;
  const [models, setModels] = (0, _react.useState)(() => list.map(item => ({
    id: generateId(),
    ...getModelValue(item)
  })));
  const hasInvalidValues = models.some(config.hasInvalidValuesFn);
  const updateValues = (0, _react.useCallback)(modelList => {
    setModels(modelList);
    onChange(modelList.map(onChangeFn));
  }, [onChangeFn, onChange]);
  const onChangeValue = (0, _react.useCallback)((index, value, modelName) => {
    const {
      model,
      isInvalid
    } = validateValue(value, validateClass);
    updateValues(models.map((range, arrayIndex) => arrayIndex === index ? {
      ...range,
      [modelName]: {
        value,
        model,
        isInvalid
      }
    } : range));
  }, [models, updateValues, validateClass]);
  const onDelete = (0, _react.useCallback)(id => updateValues(models.filter(model => model.id !== id)), [models, updateValues]);
  const onAdd = (0, _react.useCallback)(() => updateValues([...models, {
    id: generateId(),
    ...getModelValue()
  }]), [getModelValue, models, updateValues]);
  (0, _react.useEffect)(() => {
    // resposible for setting up an initial value when there is no default value
    if (!list.length) {
      updateValues([{
        id: generateId(),
        ...defaultValue
      }]);
    }
  }, [defaultValue, list.length, updateValues]);
  (0, _react.useEffect)(() => {
    setValidity(!hasInvalidValues);
  }, [hasInvalidValues, setValidity]);
  (0, _react.useEffect)(() => {
    // responsible for discarding changes
    if (list.length !== models.length || list.some((item, index) => {
      // make model to be the same shape as stored value
      const model = (0, _lodash.mapValues)((0, _lodash.pick)(models[index], modelNames), 'model');

      // we need to skip empty values since they are not stored in saved object
      return !(0, _lodash.isEqual)(item, (0, _lodash.omitBy)(model, _lodash.isEmpty));
    })) {
      setModels(list.map(item => ({
        id: generateId(),
        ...getModelValue(item)
      })));
    }
  }, [getModelValue, list, modelNames, models]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, models.map((item, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: item.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, config.renderInputRow(item, index, onChangeValue), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": config.getRemoveBtnAriaLabel(item),
    title: config.getRemoveBtnAriaLabel(item),
    disabled: models.length === 1,
    color: "danger",
    iconType: "trash",
    onClick: () => onDelete(item.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.ipRanges.addRangeButtonLabel",
    defaultMessage: "Add range",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }))));
}