"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useINPQuery = useINPQuery;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _inp_query = require("../services/data/inp_query");
var _use_data_view = require("../components/app/rum_dashboard/local_uifilters/use_data_view");
var _call_date_math = require("../services/data/call_date_math");
var _core_web_vitals_query = require("../services/data/core_web_vitals_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useINPQuery(uxQuery) {
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data: esQueryResponse,
    loading
  } = (0, _public.useEsSearch)({
    index: uxQuery ? dataViewTitle : undefined,
    ...(0, _inp_query.inpQuery)((0, _call_date_math.callDateMath)(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.start), (0, _call_date_math.callDateMath)(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.end), uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.urlQuery, uxQuery !== null && uxQuery !== void 0 && uxQuery.uiFilters ? JSON.parse(uxQuery.uiFilters) : {}, uxQuery !== null && uxQuery !== void 0 && uxQuery.percentile ? Number(uxQuery.percentile) : undefined)
  }, [uxQuery, dataViewTitle], {
    name: 'UxINPMetrics'
  });
  const data = (0, _react.useMemo)(() => (0, _inp_query.transformINPResponse)(esQueryResponse, uxQuery !== null && uxQuery !== void 0 && uxQuery.percentile ? Number(uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.percentile) : _core_web_vitals_query.PERCENTILE_DEFAULT), [esQueryResponse, uxQuery === null || uxQuery === void 0 ? void 0 : uxQuery.percentile]);
  return {
    data,
    loading
  };
}