"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARD_LABEL = void 0;
exports.RumHome = RumHome;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _web_application_select = require("./panels/web_application_select");
var _user_percentile = require("./user_percentile");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_has_rum_data = require("./hooks/use_has_rum_data");
var _rum_datepicker = require("./rum_datepicker");
var _empty_state_loading = require("./empty_state_loading");
var _use_kibana_services = require("../../../hooks/use_kibana_services");
var _environment_filter = require("./environment_filter");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/rum_home.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DASHBOARD_LABEL = exports.DASHBOARD_LABEL = _i18n.i18n.translate('xpack.ux.title', {
  defaultMessage: 'Dashboard'
});
function RumHome() {
  const {
    docLinks,
    http,
    observabilityShared,
    observabilityAIAssistant
  } = (0, _use_kibana_services.useKibanaServices)();
  const PageTemplateComponent = observabilityShared.navigation.PageTemplate;
  const {
    hasData,
    loading: isLoading,
    dataViewTitle
  } = (0, _use_has_rum_data.useHasRumData)();
  const noDataConfig = !hasData ? {
    action: {
      elasticAgent: {
        title: _i18n.i18n.translate('xpack.ux.overview.beatsCard.title', {
          defaultMessage: 'Add RUM data'
        }),
        description: _i18n.i18n.translate('xpack.ux.overview.beatsCard.description', {
          defaultMessage: 'Enable RUM with the APM agent to collect user experience data.'
        }),
        href: http.basePath.prepend('/app/apm/tutorial'),
        buttonText: _i18n.i18n.translate('xpack.ux.overview.beatsCard.buttonLabel', {
          defaultMessage: 'Add RUM data'
        }),
        docsLink: docLinks.links.observability.guide,
        'data-test-subj': 'rumNoDataCard'
      }
    }
  } : undefined;
  let screenDescription = '';
  if (!hasData) {
    screenDescription = `The user is looking at a Getting Started screen that is displayed because no data could be retrieved.`;
  }
  if (dataViewTitle) {
    screenDescription = `${screenDescription} The index that was used to query the system is called ${dataViewTitle}.`;
  } else {
    screenDescription = `${screenDescription} The index that was used to query the system is undefined, so it is not configured yet.`;
  }
  (0, _react.useEffect)(() => {
    return observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.setScreenContext({
      screenDescription,
      starterPrompts: [...(!hasData ? [{
        title: _i18n.i18n.translate('xpack.ux.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.ux.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: "Why don't I see any data?"
        }),
        icon: 'sparkles'
      }] : [])]
    });
  }, [hasData, observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service, screenDescription]);
  return /*#__PURE__*/_react.default.createElement(PageTemplateComponent, {
    noDataConfig: isLoading ? undefined : noDataConfig,
    pageHeader: {
      children: /*#__PURE__*/_react.default.createElement(PageHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 31
        }
      })
    },
    isPageDataLoaded: isLoading === false,
    isEmptyState: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_empty_state_loading.EmptyStateLoading, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      visibility: isLoading ? 'hidden' : 'initial'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_.RumOverview, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })));
}
function PageHeader() {
  const sizes = (0, _use_breakpoints.useBreakpoints)();
  const datePickerStyle = sizes.isMedium ? {} : {
    maxWidth: '70%'
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    className: "eui-textNoWrap",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, DASHBOARD_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignItems: 'flex-end',
      ...datePickerStyle
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_rum_datepicker.RumDatePicker, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_web_application_select.WebApplicationSelect, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_user_percentile.UserPercentile, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_environment_filter.UxEnvironmentFilter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }))));
}