"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WebApplicationSelect = WebApplicationSelect;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _service_name_query = require("../../../../services/data/service_name_query");
var _service_name_filter = require("../url_filter/service_name_filter");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_data_view = require("../local_uifilters/use_data_view");
var _call_date_math = require("../../../../services/data/call_date_math");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/panels/web_application_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function WebApplicationSelect() {
  var _data$aggregations$se, _data$aggregations, _data$aggregations$se2;
  const {
    rangeId,
    urlParams: {
      start,
      end
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    data,
    loading
  } = (0, _public.useEsSearch)({
    index: dataViewTitle,
    ...(0, _service_name_query.serviceNameQuery)((0, _call_date_math.callDateMath)(start), (0, _call_date_math.callDateMath)(end))
  },
  // `rangeId` works as a cache buster for ranges that never change, like `Today`
  [start, end, rangeId, dataViewTitle], {
    name: 'UxApplicationServices'
  });
  const rumServiceNames = (_data$aggregations$se = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$se2 = _data$aggregations.services) === null || _data$aggregations$se2 === void 0 ? void 0 : _data$aggregations$se2.buckets.map(({
    key
  }) => key)) !== null && _data$aggregations$se !== void 0 ? _data$aggregations$se : [];
  return /*#__PURE__*/_react.default.createElement(_service_name_filter.ServiceNameFilter, {
    loading: loading !== null && loading !== void 0 ? loading : true,
    serviceNames: rumServiceNames,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 10
    }
  });
}