"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoadDistribution = PageLoadDistribution;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
var _breakdown_filter = require("../breakdowns/breakdown_filter");
var _page_load_dist_chart = require("../charts/page_load_dist_chart");
var _reset_percentile_zoom = require("./reset_percentile_zoom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/page_load_distribution/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PageLoadDistribution() {
  const [percentileRange, setPercentileRange] = (0, _react.useState)({
    min: null,
    max: null
  });
  const [breakdown, setBreakdown] = (0, _react.useState)(null);
  const onPercentileChange = (0, _react.useCallback)((min, max) => {
    setPercentileRange({
      min,
      max
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-cy": "pageLoadDist",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 13
    }
  }, _translations.I18LABELS.pageLoadDistribution))), /*#__PURE__*/_react.default.createElement(_reset_percentile_zoom.ResetPercentileZoom, {
    percentileRange: percentileRange,
    setPercentileRange: setPercentileRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 170
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_breakdown_filter.BreakdownFilter, {
    selectedBreakdown: breakdown,
    onBreakdownChange: setBreakdown,
    dataTestSubj: 'pldBreakdownFilter',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_page_load_dist_chart.PageLoadDistChart, {
    onPercentileChange: onPercentileChange,
    breakdown: breakdown,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}