"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsmSharedContext = void 0;
exports.CsmSharedContextProvider = CsmSharedContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_dynamic_data_view = require("../../../../hooks/use_dynamic_data_view");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/csm_shared_context/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultContext = {
  sharedData: {
    totalPageViews: 0
  },
  setSharedData: d => {
    throw new Error('setSharedData was not initialized, set it when you invoke the context');
  }
};
const CsmSharedContext = exports.CsmSharedContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
function CsmSharedContextProvider({
  children
}) {
  const [newData, setNewData] = (0, _react.useState)({
    totalPageViews: 0
  });
  const [dataView, setDataView] = (0, _react.useState)();
  const setSharedData = _react.default.useCallback(data => {
    setNewData(data);
  }, []);
  const {
    services: {
      dataViews
    }
  } = (0, _public.useKibana)();
  const {
    dataViewTitle
  } = (0, _use_dynamic_data_view.useDynamicDataViewTitle)();
  const {
    data
  } = (0, _use_fetcher.useFetcher)(async () => {
    if (dataViewTitle) {
      return dataViews.create({
        title: dataViewTitle,
        timeFieldName: '@timestamp'
      });
    }
  }, [dataViewTitle, dataViews]);
  (0, _react.useEffect)(() => {
    setDataView(data);
  }, [data]);
  const value = (0, _react.useMemo)(() => {
    return {
      sharedData: newData,
      setSharedData,
      dataView
    };
  }, [newData, setSharedData, dataView]);
  return /*#__PURE__*/_react.default.createElement(CsmSharedContext.Provider, {
    value: value,
    children: children,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 10
    }
  });
}