"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXActionMenu = UXActionMenu;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _inpector_link = require("./inpector_link");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/action_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ANALYZE_DATA = _i18n.i18n.translate('xpack.ux.analyzeDataButtonLabel', {
  defaultMessage: 'Explore data'
});
const ANALYZE_MESSAGE = _i18n.i18n.translate('xpack.ux.analyzeDataButtonLabel.message', {
  defaultMessage: 'Go to Explore Data, where you can select and filter result data in any dimension and look for the cause or impact of performance problems.'
});
function UXActionMenu({
  appMountParameters,
  isDev
}) {
  const {
    http,
    application
  } = (0, _use_kibana_services.useKibanaServices)();
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    rangeTo,
    rangeFrom,
    serviceName
  } = urlParams;
  const uxExploratoryViewLink = (0, _public2.createExploratoryViewUrl)({
    reportType: 'kpi-over-time',
    allSeries: [{
      dataType: 'ux',
      name: `${serviceName}-page-views`,
      time: {
        from: rangeFrom,
        to: rangeTo
      },
      reportDefinitions: {
        [_elasticsearch_fieldnames.SERVICE_NAME]: serviceName ? [serviceName] : []
      },
      selectedMetricField: _public2.RECORDS_FIELD
    }]
  }, http.basePath.get());
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: appMountParameters.setHeaderActionMenu,
    theme$: appMountParameters.theme$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_inpector_link.UxInspectorHeaderLink, {
    isDev: isDev,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 49
      }
    }, ANALYZE_MESSAGE),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "data-test-subj": "uxAnalyzeBtn",
    color: "primary",
    href: uxExploratoryViewLink,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, ANALYZE_DATA)), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    href: application.getUrlForApp('/apm/tutorial'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ux.addDataButtonLabel', {
    defaultMessage: 'Add data'
  }))))));
}