"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsPath = exports.getDataPath = exports.getConfigPath = exports.getConfigDirectory = exports.config = void 0;
var _path = require("path");
var _fs = require("fs");
var _configSchema = require("@kbn/config-schema");
var _repoInfo = require("@kbn/repo-info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isString = v => typeof v === 'string';
const CONFIG_PATHS = [process.env.KBN_PATH_CONF && (0, _path.join)(process.env.KBN_PATH_CONF, 'kibana.yml'), (0, _path.join)(_repoInfo.REPO_ROOT, 'config/kibana.yml'), '/etc/kibana/kibana.yml'].filter(isString);
const CONFIG_DIRECTORIES = [process.env.KBN_PATH_CONF, (0, _path.join)(_repoInfo.REPO_ROOT, 'config'), '/etc/kibana'].filter(isString);
const DATA_PATHS = [(0, _path.join)(_repoInfo.REPO_ROOT, 'data'), '/var/lib/kibana'].filter(isString);
const LOGS_PATHS = [(0, _path.join)(_repoInfo.REPO_ROOT, 'logs'), '/var/log/kibana'].filter(isString);
function findFile(paths) {
  const availablePath = paths.find(configPath => {
    try {
      (0, _fs.accessSync)(configPath, _fs.constants.R_OK);
      return true;
    } catch (e) {
      // Check the next path
    }
  });
  return availablePath || paths[0];
}

/**
 * Get the path of kibana.yml
 * @internal
 */
const getConfigPath = () => findFile(CONFIG_PATHS);

/**
 * Get the directory containing configuration files
 * @internal
 */
exports.getConfigPath = getConfigPath;
const getConfigDirectory = () => findFile(CONFIG_DIRECTORIES);

/**
 * Get the directory containing runtime data
 * @internal
 */
exports.getConfigDirectory = getConfigDirectory;
const getDataPath = () => findFile(DATA_PATHS);

/**
 * Get the directory containing logs
 * @internal
 */
exports.getDataPath = getDataPath;
const getLogsPath = () => findFile(LOGS_PATHS);
exports.getLogsPath = getLogsPath;
const config = exports.config = {
  path: 'path',
  schema: _configSchema.schema.object({
    data: _configSchema.schema.string({
      defaultValue: () => getDataPath()
    })
  })
};