"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfilesSelectable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _user_avatar = require("./user_avatar");
var _user_profile = require("./user_profile");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-user-profile-components/src/user_profiles_selectable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NULL_OPTION_KEY = 'null';

/**
 * Props of {@link UserProfilesSelectable} component
 */

/**
 * Renders a selectable component given a list of user profiles
 */
const UserProfilesSelectable = ({
  selectedOptions,
  defaultOptions,
  options,
  onChange,
  onSearchChange,
  isLoading = false,
  singleSelection = false,
  limit,
  height,
  loadingMessage,
  noMatchesMessage,
  emptyMessage,
  errorMessage,
  searchPlaceholder,
  searchInputId,
  selectedStatusMessage,
  limitReachedMessage,
  nullOptionLabel,
  nullOptionProps,
  defaultOptionsLabel,
  clearButtonLabel,
  ...props
}) => {
  const [displayedOptions, setDisplayedOptions] = (0, _react.useState)([]);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const selectedCount = selectedOptions ? selectedOptions.length : 0;
  const limitReached = limit ? selectedCount >= limit : false;

  // Resets all displayed options
  const resetDisplayedOptions = () => {
    if (options) {
      setDisplayedOptions(options.map(option => toSelectableOption(option, nullOptionLabel, nullOptionProps)));
      return;
    }
    setDisplayedOptions([]);
    updateDisplayedOptions();
  };
  const ensureSeparator = values => {
    let index = values.findIndex(option => option.isGroupLabel);
    if (index === -1) {
      const length = values.push({
        label: defaultOptionsLabel !== null && defaultOptionsLabel !== void 0 ? defaultOptionsLabel : _i18n.i18n.translate('userProfileComponents.userProfilesSelectable.defaultOptionsLabel', {
          defaultMessage: 'Suggested'
        }),
        isGroupLabel: true
      });
      index = length - 1;
    }
    return index;
  };

  // Updates displayed options without removing or resorting exiting options
  const updateDisplayedOptions = () => {
    if (options) {
      return;
    }
    setDisplayedOptions(values => {
      // Copy all displayed options
      const nextOptions = [...values];

      // Get any newly added selected options
      const selectedOptionsToAdd = selectedOptions ? selectedOptions.filter(profile => !nextOptions.find(option => isMatchingOption(option, profile))).map(option => toSelectableOption(option, nullOptionLabel, nullOptionProps)) : [];

      // Get any newly added default options
      const defaultOptionsToAdd = defaultOptions ? defaultOptions.filter(profile => !nextOptions.find(option => isMatchingOption(option, profile)) && !selectedOptionsToAdd.find(option => isMatchingOption(option, profile))).map(option => toSelectableOption(option, nullOptionLabel, nullOptionProps)) : [];

      // Merge in any new options and add group separator if necessary
      if (defaultOptionsToAdd.length) {
        const separatorIndex = ensureSeparator(nextOptions);
        nextOptions.splice(separatorIndex, 0, ...selectedOptionsToAdd);
        nextOptions.push(...defaultOptionsToAdd);
      } else {
        nextOptions.push(...selectedOptionsToAdd);
      }
      return nextOptions;
    });
  };

  // Marks displayed options as checked or unchecked depending on `props.selectedOptions`
  const updateCheckedStatus = () => {
    setDisplayedOptions(values => values.map(option => {
      if (selectedOptions) {
        var _option$data$data;
        const match = selectedOptions.find(profile => isMatchingOption(option, profile));
        const checked = match === undefined ? undefined : 'on';
        const disabled = checked ? false : limitReached;
        return {
          ...option,
          checked,
          disabled,
          prepend: option.data ? /*#__PURE__*/_react.default.createElement(_user_avatar.UserAvatar, {
            user: option.data.user,
            avatar: (_option$data$data = option.data.data) === null || _option$data$data === void 0 ? void 0 : _option$data$data.avatar,
            size: "s",
            isDisabled: disabled,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 247,
              columnNumber: 15
            }
          }) : undefined
        };
      }
      return {
        ...option,
        checked: undefined,
        disabled: undefined
      };
    }));
  };
  (0, _react.useEffect)(resetDisplayedOptions, [options]); // eslint-disable-line react-hooks/exhaustive-deps
  (0, _react.useEffect)(updateDisplayedOptions, [defaultOptions, selectedOptions]); // eslint-disable-line react-hooks/exhaustive-deps
  (0, _react.useEffect)(updateCheckedStatus, [options, defaultOptions, selectedOptions]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": props['data-test-subj'],
    options: displayedOptions,
    onChange: nextOptions => {
      if (!onChange) {
        return;
      }

      // Take all selected options from `nextOptions` unless already in `props.selectedOptions`
      // @ts-expect-error
      const values = nextOptions.filter(option => {
        if (option.isGroupLabel || option.checked !== 'on') {
          return false;
        }
        if (selectedOptions && selectedOptions.find(profile => isMatchingOption(option, profile)) !== undefined) {
          return false;
        }
        return true;
      }).map(option => option.key === NULL_OPTION_KEY ? null : option.data);

      // Add all options from `props.selectedOptions` unless they have been deselected in `nextOptions`
      if (selectedOptions && !singleSelection) {
        selectedOptions.forEach(profile => {
          const match = nextOptions.find(option => isMatchingOption(option, profile));
          if (match === undefined || match.checked === 'on') {
            if (match && match.key === NULL_OPTION_KEY) {
              values.unshift(profile);
            } else {
              values.push(profile);
            }
          }
        });
      }
      onChange(values);
    },
    css: {
      maxHeight: height
    },
    singleSelection: singleSelection,
    searchable: true,
    searchProps: {
      placeholder: searchPlaceholder !== null && searchPlaceholder !== void 0 ? searchPlaceholder : _i18n.i18n.translate('userProfileComponents.userProfilesSelectable.searchPlaceholder', {
        defaultMessage: 'Search'
      }),
      value: searchTerm,
      onChange: value => {
        setSearchTerm(value);
        onSearchChange === null || onSearchChange === void 0 ? void 0 : onSearchChange(value);
      },
      isLoading,
      isClearable: !isLoading,
      id: searchInputId
    },
    isPreFiltered: true,
    listProps: {
      onFocusBadge: false,
      rowHeight: 48
    },
    loadingMessage: loadingMessage,
    noMatchesMessage: noMatchesMessage,
    emptyMessage: emptyMessage,
    errorMessage: errorMessage,
    renderOption: (option, searchValue) => {
      if (option.user) {
        const displayName = (0, _user_profile.getUserDisplayName)(option.user);
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 336,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
          search: searchValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 17
          }
        }, displayName)), option.user.email && option.user.email !== displayName ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: 'xs',
          color: option.disabled ? 'disabled' : 'subdued',
          className: "eui-textTruncate",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 340,
            columnNumber: 17
          }
        }, searchValue ? /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
          search: searchValue,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 346,
            columnNumber: 21
          }
        }, option.user.email) : option.user.email) : undefined);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
        search: searchValue,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 355,
          columnNumber: 16
        }
      }, option.label);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  }, search, !singleSelection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 21
    }
  }, selectedStatusMessage ? selectedStatusMessage(selectedCount) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "userProfileComponents.userProfilesSelectable.selectedStatusMessage",
    defaultMessage: "{count, plural, one {# user selected} other {# users selected}}",
    values: {
      count: selectedCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 19
    }
  }, selectedCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: () => onChange === null || onChange === void 0 ? void 0 : onChange([]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 23
    }
  }, clearButtonLabel !== null && clearButtonLabel !== void 0 ? clearButtonLabel : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "userProfileComponents.userProfilesSelectable.clearButtonLabel",
    defaultMessage: "Remove all users",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 27
    }
  })) : undefined))) : undefined), limit && selectedCount >= limit ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: limitReachedMessage ? limitReachedMessage(limit) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "userProfileComponents.userProfilesSelectable.limitReachedMessage",
      defaultMessage: "You've selected the maximum of {count, plural, one {# user} other {# users}}",
      values: {
        count: limit
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 21
      }
    }),
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 15
    }
  })) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 11
    }
  }), list));
};
exports.UserProfilesSelectable = UserProfilesSelectable;
function toSelectableOption(userProfile, nullOptionLabel, nullOptionProps) {
  if (userProfile) {
    return {
      key: userProfile.uid,
      label: (0, _user_profile.getUserDisplayLabel)(userProfile.user),
      data: userProfile,
      'data-test-subj': `userProfileSelectableOption-${userProfile.user.username}`
    };
  }
  return {
    key: NULL_OPTION_KEY,
    label: nullOptionLabel !== null && nullOptionLabel !== void 0 ? nullOptionLabel : _i18n.i18n.translate('userProfileComponents.userProfilesSelectable.nullOptionLabel', {
      defaultMessage: 'No users'
    }),
    'data-test-subj': 'userProfileSelectableOption-null',
    ...nullOptionProps
  };
}
function isMatchingOption(option, profile) {
  return option.key === (profile ? profile.uid : NULL_OPTION_KEY);
}