"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackApplicationUsageChange = trackApplicationUsageChange;
var _rxjs = require("rxjs");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * List of appIds not to report usage from (due to legacy hacks)
 */
const DO_NOT_REPORT = ['kibana'];
function trackApplicationUsageChange(currentAppId$, applicationUsageTracker) {
  const windowClickSubscrition = (0, _rxjs.fromEvent)(window, 'click').subscribe(() => {
    applicationUsageTracker.updateViewClickCounter(_constants.MAIN_APP_DEFAULT_VIEW_ID);
  });
  const appIdSubscription = currentAppId$.pipe((0, _rxjs.filter)(appId => typeof appId === 'string' && !DO_NOT_REPORT.includes(appId)), (0, _rxjs.distinctUntilChanged)()).subscribe(appId => {
    if (!appId) {
      return;
    }
    applicationUsageTracker.setCurrentAppId(appId);
    applicationUsageTracker.trackApplicationViewUsage(_constants.MAIN_APP_DEFAULT_VIEW_ID);
  });
  return [windowClickSubscrition, appIdSubscription];
}